<CsoundSynthesizer>
<CsOptions>
</CsOptions>
<CsInstruments>
 
 sr = 44100
 kr = 4410
 ksmps = 10
 nchnls=2
 garvbsig init 0


;-------------------------------------------------
; ********** The Electric Priest ***" Talking "***
;-------------------------------------------------
instr 1
inote=cpspch(p5)
irvbgain = p8
k2 	linseg  	0, p3*.9, 0, p3*.1, 1  			; octaviation coefficient
a1	oscil 	7, .15,1					;Rubato for vibrato
a3	linen		a1, (p3-p3*.05), p3, .2			;delay for vibrato
a2	oscil 	a3, 5,1					;vibrato
a5	linen		1250, p7, p3, (p3*.1)			;amp envelope

a21	line	456, p6, 1030					; p6: morph-time,0=instant aah					
a5	linen		10000, p7, p3, (p3*.1)			;amp envelope
a11 fof	a5,inote+a2, a21*(p4/100), k2, 200, .003, .017, .005, 10, 1,2, inote, 0, 1

a31	line	4000, p6, 6845
a32	line	2471, p6, 1370										
a6	linen		a31, p7, p3, (p3*.1)			;amp envelope
a12 fof      a6,inote+a2, a32*(p4/100), k2, 200, .003, .017, .005, 20, 1,2, inote, 0, 1

a41	line	2813, p6, 3170
a42	line	1650, p6, 1845										
a7	linen		a42, p7, p3, (p3*.1)			;amp envelope
a13 fof      a7,inote+a2, a41*(p4/100), k2, 200, .003, .017, .005, 20, 1,2, inote, 0, 1

a71	line	1347, p6, 1726 	;amp line
a72	line	3839, p6, 3797	; form line										
a8	linen		a71, p7, p3, (p3*.1)			;amp envelope
a14 fof      a8,inote+a2, a72*(p4/100), k2, 200, .003, .017, .005, 30, 1,2, inote, 0, 1

a51	line	1, p6, 1250										
a9	linen		a51, p7, p3, (p3*.1)			;amp envelope
a15 fof      a5,inote+a2, 4177*(p4/100), k2, 200, .003, .017, .005, 30, 1,2, inote, 0, 1

a61	line	1, p6, 5833
a10	linen		a51, p7, p3, (p3*.1)			;amp envelope
a16 fof      a10,inote+a2,  428*(p4/100), k2, 200, .003, .017, .005, 10, 1,2, inote, 0, 1
a7 =        (a11 + a12 + a13 + a14 + a15 + a16) * p9 / 10

outs  a7*.9,a7*.6
garvbsig = garvbsig+(a7)*irvbgain
endin

;------------------------------------------
; ********** The Electric Priest ***Aaah**
;------------------------------------------
instr 2
inote=cpspch(p5)
irvbgain = p8
k2 	linseg  	0, p3*.9, 0, p3*.1, 1  			; octaviation coefficient
a1	oscil 	5, .12,1					;Rubato for vibrato
a3	linen		a1, (p3-p3*.02), p3, .2			;delay for vibrato
a2	oscil 	a3, 4,1					;vibrato
a4	linen		(p4*.4), p6, p3, (p3*.05)		;format env shape
a5	linen		1250, p7, p3, (p3*.15)			;amp envelope

a21	oscil 	2, 10,1					
a5	linen		9998+a21, p7, p3, (p3*.1)			;amp envelope
a11 fof	a5,inote+a2*.5, a4+1030*(p4/100), k2, 200, .003, .017, .005, 10, 1,2, inote, 0, 1

a22	oscil 	2, 2,1
a6	linen		6843+a22, p7, p3, (p3*.1)			;amp envelope
a12 fof      a6,inote+a2*.5, a4+1370*(p4/100), k2, 200, .003, .017, .005, 20, 1,2, inote, 0, 1

a23	oscil 	1, 12,1
a7	linen		1845, p7, p3, (p3*.1)			;amp envelope
a13 fof      a7,inote+a2*.5, a4+3170*(p4/100), k2, 200, .003, .017, .005, 20, 1,2, inote, 0, 1

a24	oscil 	2, 5,1
a8	linen		1726+a24, p7, p3, (p3*.1)			;amp envelope
a14 fof      a8,inote+a2*.5, a4+3797*(p4/100), k2, 200, .003, .017, .005, 30, 1,2, inote, 0, 1

a25	oscil 	3, 4,1
a9	linen		1250+a25, p7, p3, (p3*.1)			;amp envelope
a15 fof      a5,inote+a2*.5, a4+4177*(p4/100), k2, 200, .003, .017, .005, 30, 1,2, inote, 0, 1


a26	oscil 	3, 6,1
a10	linen		5833+a26, p7, p3, (p3*.1)			;amp envelope
a16 fof      a10,inote+a2*.5,  a4+428*(p4/100), k2, 200, .003, .017, .005, 10, 1,2, inote, 0, 1
a7 =        (a11 + a12 + a13 + a14 + a15 + a16) * p9 / 10
outs  a7*p6,a7*(1-p6)
garvbsig = garvbsig+(a7)*irvbgain
endin


;-------------------------------------------------
; ********** The Electric Priest ***" gliss "***
;-------------------------------------------------
instr 4
inote=cpspch(p5)
irvbgain = p8
k2 	linseg  	0, p3*.9, 0, p3*.1, 1  			; octaviation coefficient
a1	oscil 	7, .15,1					;Rubato for vibrato
a3	linen		a1, (p3-p3*.05), p3, .2			;delay for vibrato
a2	oscil 	a3, 5,1					;vibrato
a5	linen		1250, p7, p3, (p3*.1)			;amp envelope
a90	oscil 	30, .15625,1					;gliss: 1 cycle per 4 bars if 0.4sec =1 quarternote

a21	line	456, p6, 1030					; p6: morph-time,0=instant aah					
a5	linen		10000, p7, p3, (p3*.1)			;amp envelope
a11 fof	a5,inote+a2+a90, a21*(p4/100), k2, 200, .003, .017, .005, 10, 1,2, inote, 0, 1

a31	line	4000, p6, 6845
a32	line	2471, p6, 1370										
a6	linen		a31, p7, p3, (p3*.1)			;amp envelope
a12 fof      a6,inote+a2+a90, a32*(p4/100), k2, 200, .003, .017, .005, 20, 1,2, inote, 0, 1

a41	line	2813, p6, 3170
a42	line	1650, p6, 1845										
a7	linen		a42, p7, p3, (p3*.1)			;amp envelope
a13 fof      a7,inote+a2+a90, a41*(p4/100), k2, 200, .003, .017, .005, 20, 1,2, inote, 0, 1

a71	line	1347, p6, 1726 	;amp line
a72	line	3839, p6, 3797	; form line										
a8	linen		a71, p7, p3, (p3*.1)			;amp envelope
a14 fof      a8,inote+a2+a90, a72*(p4/100), k2, 200, .003, .017, .005, 30, 1,2, inote, 0, 1

a51	line	1, p6, 1250										
a9	linen		a51, p7, p3, (p3*.1)			;amp envelope
a15 fof      a5,inote+a2+a90, 4177*(p4/100), k2, 200, .003, .017, .005, 30, 1,2, inote, 0, 1

a61	line	1, p6, 5833
a10	linen		a51, p7, p3, (p3*.1)			;amp envelope
a16 fof      a10,inote+a2+a90,  428*(p4/100), k2, 200, .003, .017, .005, 10, 1,2, inote, 0, 1
a7 =        (a11 + a12 + a13 + a14 + a15 + a16) * p9 / 10

outs  a7*.9,a7*.6
garvbsig = garvbsig+(a7)*irvbgain
endin



;*******************************************************************************************

;|||||||||||||||||
;||-Sonar Noise-||
;|||||||||||||||||
instr 5
irvbgain = p7
i1 = cpspch(p4)
k1 expseg .0001,.01,p5,p3-.01,.0001
a1 rand k1
a2 reson a1,i1,i1/25,1
a3 balance a2,a1
a1 = a3*p6
a2 = a3*(1-p6)
outs a1,a2
garvbsig = garvbsig+(a1+a2)*irvbgain
endin


	
; Soft OSCIL/fof instrument, p3:dur p4:amp p5:pitch p6:reverb p7:att p8:rel p9:bal
instr 3
irvbgain = p6
inote=cpspch(p5)
ibalance=	p9	
k1	oscil 	300, .2,1				
k2	oscil		200, .5,1
k3	oscil		400, .05,1				; res sweep

a1	oscil		p4*0.30, inote*0.998, 4
a2	oscil		p4*0.30, inote*1.002, 4
a3	oscil		p4*0.20, inote*1.000, 5
a4   	fof  		p4*0.20+k2, inote, 600, 0, 40, .003, .02, .007, 10, 1, 2, p3

amix= a1+a2+a3+a4
a6	butterlp	amix,k1+1000,50		;input, freq, Q
a7	butterlp	a6, k1+1000,50
a8	butterhp	a7, 600	
a9	reson		a8, k3+2000, 50
a10	butterhp	a9*.2+a8*1, 150	
a11	butterlp	a10,9000
aenv	linen		a11, p7, p3, p8
outs aenv*ibalance, aenv*(1-ibalance)
garvbsig = garvbsig+(aenv)*irvbgain
endin

; Bass OSCIL/FM instrument, p3:dur p4:amp p5:pitch p6:reverb p7:att p8:rel p9:bal
instr 10
irvbgain = p6
inote=cpspch(p5)
ibalance=	p9	
k1	line	 	2500, p3*.8,1500				
k3	line	 	6000, p3*.5,500				; res sweep
k2	linen		k3, .08, p3*.5, .5

a1	oscil		p4*0.40, inote*0.998-.12, 06
a2	oscil		p4*0.40, inote*1.002-.12, 03
a3	oscil		p4*0.40, inote*1.002-.12, 06
a4	oscil		p4*0.70, inote-.24, 03

amix= a1+a2+a3+a4
a6	butterlp	amix,k2,20		;input, freq, Q
a8	butterlp	(a6), k2,20
a9	butterhp	a8, 65	
a10	butterhp	a9, 65	
a11	butterlp	a10,1000
aenv	linen		a11, p7, p3, p8
outs aenv*ibalance, aenv*(1-ibalance)
garvbsig = garvbsig+(aenv)*irvbgain
endin


;'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
; Pan Noise
;'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
instr 21
irvbgain = p6
i1	=	octpch(p5)			; center pitch, to be modified
k1	randh	10,10, .5				; 10 time/sec by random displacements up to 1 octave
a1	oscil	p7, cpsoct(i1+k1), 10
a2	reson		a1,1000,50
a3	butterlp	a2*.4+a1,2500
a4	butterlp	a3,2500
a5	butterhp	a4,950
a6	butterhp	a5,950
aenv	linen		a6, p3*.2, p3, p3*2
a7	oscil	1, .4, 03
outs aenv*a7, aenv*(1-a7)
garvbsig = garvbsig+a1*irvbgain
endin

;'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
; Hi-Hat Noise 
;'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
instr 22
irvbgain = p6
ibalance=	p4
k1	expon		10000, .1, 2500
a0	expon		p7+150, .1, 10
a1	rand		a0
a3	butterlp	a1,k1
a4	butterlp	a3,k1
a5	butterhp	a4,3500
a6	butterhp	a5,3500
a8	linen		(a6+a1),0,p3, .05  

outs a8*ibalance, a8*(1-ibalance)
garvbsig = garvbsig+a1*irvbgain
endin
;'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''

;______
;METAL
;------
instr 23
irvbgain = p6
ibalance=	p4
i1	=	octpch(p5)			; center pitch, to be modified

a1	fmmetal	31129.60*p7, p5, 1,   1.2, 0.2, 5.5, 1,5,5,1, 1
a8	linen		a1,.01,p3, p3*.3  

outs a8*ibalance, a8*(1-ibalance)
garvbsig = garvbsig+a1*irvbgain
endin


; Kick Drum 
instr 25
irvbgain = p4

k1	expon		120, .2, 50		
k2	expon		500, .4, 200
a1	oscil		p5, k1, 03          ; Sine wave
a2	reson		a1, k2, 50
a3	butterlp	a2+a1,k1,20
a4	butterlp	a3,k1,20
a5	butterlp	a4,2500, 50
a6	butterhp	a5,50
a7	butterhp	a6,50
a8	linen		a7,0.01,p3, .2  

outs a8, a8
garvbsig = garvbsig+a1*irvbgain
endin



; Global Reverb
instr	99
irvbtime= p4
asig reverb garvbsig, irvbtime
outs asig,asig
garvbsig = 0
endin


</CsInstruments>

<CsScore>
f1  0   4096 10  1					;fof
f2  0   1024 19  .5  .5  270  .5			;fof
f03 0   1024 10  1					;sine
f04 0   1024 7  0 124 1 900 0				;saw
f05 0   1024 7  0 124 1 900 1 1 1 1 1 1 1 1 	;Buzz
f06 0   2048 10 1 1 1 1 .7 .5 .3 .1 		;pulse
f10 0   1024   21  1					;noise

;----------------------------------------------------
;	strt	dur	rvrb time
i99	0	170 	2.5
;----------------------------------------------------




;-------------------------------------------------
; ********** The Electric Priest ***" Talking "***
;-------------------------------------------------
;   strt 	dur 	form	pitch	p6;formant attack	p7; Amp attack P8;reverb p9: amp	
i1  25.6  	3.2 	70	7.00	6			3.5			.1		6
i1  +  	.4	.	7.00	20			.1			.		.
i1  +  	.	.	7.00	.3			.1			.		.
i1  +  	.	.	7.02	20			.1			.		.
i1  +  	.	.	7.03	.6			.1			.		.
i1  +  	.	.	7.03	20			.1			.		.
i1  +  	1.6	.	7.05	2			.8			.		.
i1  +  	3.2	.	7.03	200			.4			.		.

;   strt 	dur 	form	pitch	p6: Pan          	p7; Amp attack P8;reverb p9: amp	
i1  35.6  	 .8 	.	7.08	11			.2			.0		0
i1  +  	4.0 	.	7.08	11			1.8			.2		2
i1  +  	.4	.	7.10	.4			.05			.		.
i1  +  	6.4 	.	7.07	13			.1			.		.
i2  40.8  	6.4 	70	6.12 	.3			2			.1		3

; 13,5 bar
;ends at 47,2

i1  60.8  	3.2 	70	7.02	6			3.5			.1		6
i1  +  	.4	.	7.02	20			.1			.07		.
i1  +  	.	.	7.02	.3			.1			.		.
i1  +  	.	.	7.04	20			.1			.		.
i1  +  	.	.	7.05	.6			.1			.		.
i1  +  	.	.	7.05	20			.1			.		.
i1  +  	1.6	.	7.07	2			.8			.		.
i1  +  	3.2	.	7.05	200			.4			.		.

;70,8
;   strt 	dur 	form	pitch	p6: Pan          	p7; Amp attack P8;reverb p9: amp	
i1  +  	 .8 	.	7.10	11			.2			.0		0
i1  +  	4.4 	.	7.10	11			1.8			.2		3
i1  +  	.8	.	7.12	.4			.05			.		.
i1  +  	6.4 	.	7.09	13			.1			.		.

;14bar


i1  134.8  	.4	.	7.02	20			.1			.1		1.5
i1  +  	.	.	.	.3			.			.		.
i1  +  	.	.	.	20			.			.		.
i1  +  	.	.	.	.3			.			.		.

i1  +  	.8	.	.	20			.			.		.
i1  +  	.8	.	.	.3			.			.		.

i1  +  	.4	.	.	20			.			.		.
i1  +  	.	.	.	.3			.			.		.
i1  +  	.	.	.	20			.			.		.
i1  +  	.	.	.	.3			.			.		.

i1  +  	.8	.	.	20			.			.		.
i1  +  	.8	.	.	.3			.			.		.



i1  141.2  	3.2 	70	7.00	6			3.5			.1		6
i1  +  	.4	.	7.00	20			.1			.07		.
i1  +  	.	.	7.00	.3			.1			.		.
i1  +  	.	.	7.02	20			.1			.		.
i1  +  	.	.	7.03	.6			.1			.		.
i1  +  	.	.	7.03	20			.1			.		.
i1  +  	1.6	.	7.05	2			.8			.		.
i1  +  	3.2	.	7.03	200			.4			.		.


;   strt 	dur 	form	pitch	p6: Pan          	p7; Amp attack P8;reverb p9: amp	
i1  +  	 .8 	.	7.08	11			.2			.0		0
i1  +  	4.4 	.	7.08	11			1.8			.2		3
i1  +  	.8	.	7.10	.4			.05			.		.
i1  +  	8 	.	7.12	13			.1			.		.
i1  157.2  	8 	.	7.04	13			10			.		1


;------------------------------------------
; ********** The Electric Priest ***Aaah**
;------------------------------------------

;   strt 	dur 	form	pitch	p6: Pan	p7; Amp attack 	P8;reverb   p9: amp	
i2  4.8 	4.8 	70	6.03	0		4			.13		1.3
i2  11.2 	4.8 	70	6.00	1		3			.		.

i2  60.8 	22.4 	70	6.02	.5		11			.		.
i2  60.8 	1.6 	70	8.02	.3		.8			.1		2
i2  + 	1.2 	70	8.00	.5		.2			.		.
i2  + 	.4 	70	7.10	.5		.1			.		.
i2  + 	2.0 	70	7.09	.7		.3			.		.

i2  66.8 	.8 	70	8.02	.7		.3			.		.
i2  + 	.4 	70	8.04	.7		.1			.		.
i2  + 	.4 	70	8.02	.7		.1			.		.
i2  + 	3.2 	70	8.01	.7		.4			.		1.5
i2  + 	3.2 	70	8.00	.7		.6			.		1.1
i2  + 	3.2 	70	8.00	.7		.9			.		1


i2  102.8 	11.2 	70	7.02	.2		1.6			.07		1
i2  . 	. 	70	7.05	.7		.			.		.
i2  . 	. 	70	7.09	.7		.			.		.

i2  115.6 	12.8 	70	7.00	.2		.2			.07		.4
i2  . 	. 	70	7.03	.7		.			.		.
i2  . 	. 	70	7.07	.7		.			.		.

i2  128.4 	12.8 	70	7.02	.2		1.6			.07		.4
i2  . 	. 	70	7.05	.7		.			.		.
i2  . 	. 	70	7.09	.7		.			.		.

i2  115.6 	16 	70	7.00	.2		.2			.07		.6
i2  . 	. 	70	7.03	.7		.			.		.
i2  . 	. 	70	7.07	.7		.			.		.

i2  157.2 	8 	70	7.00	.2		1.6			.07		1
i2  . 	. 	70	7.04	.7		.			.		.
i2  . 	. 	70	7.07	.7		.			.		.


;-------------------------------------------------
; ********** The Electric Priest ***" gliss "***
;-------------------------------------------------
;   strt 	dur 	form	pitch	p6;formant attack	p7; Amp attack P8;reverb p9: amp   	
i4  128.4  	12.8 	70	7.07   6	    		.4		.2		1.2	
		


; Bass OSCIL/FM instrument 
;	strt	p3:dur p4:amp p5:pitch 	    p6:reverb 	p7:att 	p8:rel 	p9:bal

i10  	12.8  .4 	  9500   5.00	    .01      	.02    	.01		.5
i10  	+  	. 	  .      5.00   	    .       	.     	. 		. 
i10  	+  	.26667  .      5.01	    .       	.     	. 		. 
i10  	+  	.26667  .      .	          .       	.     	. 		. 
i10  	+  	.26667  .      .   	    .       	.     	. 		. 

i10  	+  	.4 	  .      5.00	    .       	.     	. 		.
i10  	+  	. 	  .      .   	    .       	.     	. 		. 
i10  	+  	. 	  .      .   	    .       	.     	. 		. 
i10  	+  	.2 	  .      6.00   	    .       	.     	. 		. 
i10  	+  	.2 	  .      .   	    .       	.     	. 		. 

i10  	+  	.4 	  .      5.00	    .       	.02    	.01		.5
i10  	+  	. 	  .      .   	    .       	.     	. 		. 
i10  	+  	.26667  .      5.01	    .       	.     	. 		. 
i10  	+  	.26667  .      .	          .       	.     	. 		. 
i10  	+  	.26667  .      .   	    .       	.     	. 		. 

i10  	+  	.4   	  .      5.00	    .       	.     	. 		.
i10  	+  	. 	  .      .   	    .       	.     	. 		. 
i10  	+  	. 	  .      .   	    .       	.     	. 		. 
i10  	+  	. 	  .      5.10   	    .       	.     	. 		. 

;4


i10  	+  	.4 	  .      6.00	    .       	.02    	.01		.5
i10  	+  	. 	  .      5.00   	    .       	.     	. 		. 
i10  	+  	.26667  .      5.01	    .       	.     	. 		. 
i10  	+  	.26667  .      .	          .       	.     	. 		. 
i10  	+  	.26667  .      .   	    .       	.     	. 		. 

i10  	+  	.4 	  .      5.00	    .       	.     	. 		.
i10  	+  	. 	  .      .   	    .       	.     	. 		. 
i10  	+  	. 	  .      .   	    .       	.     	. 		. 
i10  	+  	.2 	  .      6.00   	    .       	.     	. 		. 
i10  	+  	.2 	  .      .   	    .       	.     	. 		. 

i10  	+  	.4 	  .      5.00	    .       	.02    	.01		.5
i10  	+  	. 	  .      .   	    .       	.     	. 		. 
i10  	+  	.26667  .      5.01	    .       	.     	. 		. 
i10  	+  	.26667  .      .	          .       	.     	. 		. 
i10  	+  	.26667  .      .   	    .       	.     	. 		. 

i10  	+  	.4   	  .      5.00	    .       	.     	. 		.
i10  	+  	. 	  .      .   	    .       	.     	. 		. 
i10  	+  	. 	  .      .   	    .       	.     	. 		. 
i10  	+  	. 	  .      5.10   	    .       	.     	. 		. 

;8


i10  	+  	.4 	  .      6.00	    .       	.02    	.01		.5
i10  	+  	. 	  .      5.00   	    .       	.     	. 		. 
i10  	+  	.26667  .      5.01	    .       	.     	. 		. 
i10  	+  	.26667  .      .	          .       	.     	. 		. 
i10  	+  	.26667  .      .   	    .       	.     	. 		. 

i10  	+  	.4 	  .      5.00	    .       	.     	. 		.
i10  	+  	. 	  .      .   	    .       	.     	. 		. 
i10  	+  	. 	  .      .   	    .       	.     	. 		. 
i10  	+  	.2 	  .      6.00   	    .       	.     	. 		. 
i10  	+  	.2 	  .      .   	    .       	.     	. 		. 
 
i10  	+  	.4 	  .      5.00	    .       	.02    	.01		.5
i10  	+  	. 	  .      .   	    .       	.     	. 		. 
i10  	+  	.26667  .      5.01	    .       	.     	. 		. 
i10  	+  	.26667  .      .	          .       	.     	. 		. 
i10  	+  	.26667  .      .   	    .       	.     	. 		. 

i10  	+  	.4   	  .      5.00	    .       	.     	. 		.
i10  	+  	. 	  .      .   	    .       	.     	. 		. 
i10  	+  	. 	  .      .   	    .       	.     	. 		. 
i10  	+  	. 	  .      5.10   	    .       	.     	. 		. 

;12


i10  	+  	.4 	  .      6.00	    .       	.02    	.01		.5
i10  	+  	. 	  .      5.00   	    .       	.     	. 		. 
i10  	+  	.26667  .      5.01	    .       	.     	. 		. 
i10  	+  	.26667  .      .	          .       	.     	. 		. 
i10  	+  	.26667  .      .   	    .       	.     	. 		. 

i10  	+  	.4 	  .      5.00	    .       	.     	. 		.
i10  	+  	. 	  .      .   	    .       	.     	. 		. 
i10  	+  	. 	  .      .   	    .       	.     	. 		. 
i10  	+  	.2 	  .      6.00   	    .       	.     	. 		. 
i10  	+  	.2 	  .      .   	    .       	.     	. 		. 
 
i10  	+  	.4 	  .      5.00	    .       	.02    	.01		.5
i10  	+  	. 	  .      .   	    .       	.     	. 		. 
i10  	+  	.26667  .      5.01	    .       	.     	. 		. 
i10  	+  	.26667  .      .	          .       	.     	. 		. 
i10  	+  	.26667  .      .   	    .       	.     	. 		. 

i10  	+  	.4   	  .      5.00	    .       	.     	. 		.
i10  	+  	. 	  .      .   	    .       	.     	. 		. 
i10  	+  	. 	  .      .   	    .       	.     	. 		. 
i10  	+  	. 	  .      5.10   	    .       	.     	. 		. 

;16

i10  	+     .4 	  9500   5.00	    .01      	.02    	.01		.5
i10  	+  	. 	  .      5.00   	    .       	.     	. 		. 
i10  	+  	.26667  .      5.01	    .       	.     	. 		. 
i10  	+  	.26667  .      .	          .       	.     	. 		. 
i10  	+  	.26667  .      .   	    .       	.     	. 		. 

i10  	+  	.4 	  .      5.00	    .       	.     	. 		.
i10  	+  	. 	  .      .   	    .       	.     	. 		. 
i10  	+  	. 	  .      .   	    .       	.     	. 		. 
i10  	+  	.2 	  .      6.00   	    .       	.     	. 		. 
i10  	+  	.2 	  .      .   	    .       	.     	. 		. 

i10  	+  	.4 	  .      5.00	    .       	.02    	.01		.5
i10  	+  	. 	  .      .   	    .       	.     	. 		. 
i10  	+  	.26667  .      5.01	    .       	.     	. 		. 
i10  	+  	.26667  .      .	          .       	.     	. 		. 
i10  	+  	.26667  .      .   	    .       	.     	. 		. 

i10  	+  	.4   	  .      5.00	    .       	.     	. 		.
i10  	+  	. 	  .      .   	    .       	.     	. 		. 
i10  	+  	. 	  .      .   	    .       	.     	. 		. 
i10  	+  	. 	  .      5.10   	    .       	.     	. 		. 

;20


i10  	+  	.4 	  .      6.00	    .       	.02    	.01		.5
i10  	+  	. 	  .      5.00   	    .       	.     	. 		. 
i10  	+  	.26667  .      5.01	    .       	.     	. 		. 
i10  	+  	.26667  .      .	          .       	.     	. 		. 
i10  	+  	.26667  .      .   	    .       	.     	. 		. 

i10  	+  	.4 	  .      5.00	    .       	.     	. 		.
i10  	+  	. 	  .      .   	    .       	.     	. 		. 
i10  	+  	. 	  .      .   	    .       	.     	. 		. 
i10  	+  	.2 	  .      6.00   	    .       	.     	. 		. 
i10  	+  	.2 	  .      .   	    .       	.     	. 		. 

i10  	+  	.4 	  .      5.00	    .       	.02    	.01		.5
i10  	+  	. 	  .      .   	    .       	.     	. 		. 
i10  	+  	.26667  .      5.01	    .       	.     	. 		. 
i10  	+  	.26667  .      .	          .       	.     	. 		. 
i10  	+  	.26667  .      .   	    .       	.     	. 		. 

i10  	+  	.4   	  .      5.00	    .       	.     	. 		.
i10  	+  	. 	  .      .   	    .       	.     	. 		. 
i10  	+  	. 	  .      .   	    .       	.     	. 		. 
i10  	+  	. 	  .      5.10   	    .       	.     	. 		. 

;24 

i10  	+  	.4 	  .      6.00	    .       	.02    	.01		.5
i10  	+  	. 	  .      5.00   	    .       	.     	. 		. 
i10  	+  	.26667  .      5.01	    .       	.     	. 		. 
i10  	+  	.26667  .      .	          .       	.     	. 		. 
i10  	+  	.26667  .      .   	    .       	.     	. 		. 

i10  	+  	.4 	  .      5.00	    .       	.     	. 		.
i10  	+  	. 	  .      .   	    .       	.     	. 		. 
i10  	+  	. 	  .      .   	    .       	.     	. 		. 
i10  	+  	.2 	  .      6.00   	    .       	.     	. 		. 
i10  	+  	.2 	  .      .   	    .       	.     	. 		. 

i10  	+  	.4 	  .      5.00	    .       	.02    	.01		.5
i10  	+  	. 	  .      .   	    .       	.     	. 		. 
i10  	+  	.26667  .      5.01	    .       	.     	. 		. 
i10  	+  	.26667  .      .	          .       	.     	. 		. 
i10  	+  	.26667  .      .   	    .       	.     	. 		. 

i10  	+  	.4   	  .      5.00	    .       	.     	. 		.
i10  	+  	. 	  .      .   	    .       	.     	. 		. 
i10  	+  	. 	  .      .   	    .       	.     	. 		. 
i10  	+  	. 	  .      5.10   	    .       	.     	. 		. 

;28

i10  	+  	.4 	  .      6.00	    .       	.02    	.01		.5
i10  	+  	. 	  .      5.00   	    .       	.     	. 		. 
i10  	+  	.26667  .      5.01	    .       	.     	. 		. 
i10  	+  	.26667  .      .	          .       	.     	. 		. 
i10  	+  	.26667  .      .   	    .       	.     	. 		. 

i10  	+  	.4 	  .      5.00	    .       	.     	. 		.
i10  	+  	. 	  .      .   	    .       	.     	. 		. 
i10  	+  	. 	  .      .   	    .       	.     	. 		. 
i10  	+  	.2 	  .      6.00   	    .       	.     	. 		. 
i10  	+  	.2 	  .      .   	    .       	.     	. 		. 

;30 Bar= 48 sec.   section end at: 60,8




i10  	60.8  .4 	  9500   5.02	    .01      	.02    	.01		.5
i10  	+  	. 	  .      5.02   	    .       	.     	. 		. 
i10  	+  	.26667  .      5.03	    .       	.     	. 		. 
i10  	+  	.26667  .      .	          .       	.     	. 		. 
i10  	+  	.26667  .      .   	    .       	.     	. 		. 

i10  	+  	.4 	  .      5.02	    .       	.     	. 		.
i10  	+  	. 	  .      .   	    .       	.     	. 		. 
i10  	+  	. 	  .      .   	    .       	.     	. 		. 
i10  	+  	.2 	  .      6.02   	    .       	.     	. 		. 
i10  	+  	.2 	  .      .   	    .       	.     	. 		. 

i10  	+  	.4 	  .      5.02	    .       	.02    	.01		.5
i10  	+  	. 	  .      .   	    .       	.     	. 		. 
i10  	+  	.26667  .      5.03	    .       	.     	. 		. 
i10  	+  	.26667  .      .	          .       	.     	. 		. 
i10  	+  	.26667  .      .   	    .       	.     	. 		. 

i10  	+  	.4   	  .      5.02	    .       	.     	. 		.
i10  	+  	. 	  .      .   	    .       	.     	. 		. 
i10  	+  	. 	  .      .   	    .       	.     	. 		. 
i10  	+  	. 	  .      5.12   	    .       	.     	. 		. 

;4


i10  	+  	.4 	  .      6.02	    .       	.02    	.01		.5
i10  	+  	. 	  .      5.02   	    .       	.     	. 		. 
i10  	+  	.26667  .      5.03	    .       	.     	. 		. 
i10  	+  	.26667  .      .	          .       	.     	. 		. 
i10  	+  	.26667  .      .   	    .       	.     	. 		. 

i10  	+  	.4 	  .      5.02	    .       	.     	. 		.
i10  	+  	. 	  .      .   	    .       	.     	. 		. 
i10  	+  	. 	  .      .   	    .       	.     	. 		. 
i10  	+  	.2 	  .      6.02   	    .       	.     	. 		. 
i10  	+  	.2 	  .      .   	    .       	.     	. 		. 

i10  	+  	.4 	  .      5.02	    .       	.02    	.01		.5
i10  	+  	. 	  .      .   	    .       	.     	. 		. 
i10  	+  	.26667  .      5.03	    .       	.     	. 		. 
i10  	+  	.26667  .      .	          .       	.     	. 		. 
i10  	+  	.26667  .      .   	    .       	.     	. 		. 

i10  	+  	.4   	  .      5.02	    .       	.     	. 		.
i10  	+  	. 	  .      .   	    .       	.     	. 		. 
i10  	+  	. 	  .      .   	    .       	.     	. 		. 
i10  	+  	. 	  .      5.12   	    .       	.     	. 		. 

;8


i10  	+  	.4 	  .      6.02	    .       	.02    	.01		.5
i10  	+  	. 	  .      5.02   	    .       	.     	. 		. 
i10  	+  	.26667  .      5.03	    .       	.     	. 		. 
i10  	+  	.26667  .      .	          .       	.     	. 		. 
i10  	+  	.26667  .      .   	    .       	.     	. 		. 

i10  	+  	.4 	  .      5.02	    .       	.     	. 		.
i10  	+  	. 	  .      .   	    .       	.     	. 		. 
i10  	+  	. 	  .      .   	    .       	.     	. 		. 
i10  	+  	.2 	  .      6.02   	    .       	.     	. 		. 
i10  	+  	.2 	  .      .   	    .       	.     	. 		. 
 
i10  	+  	.4 	  .      5.02	    .       	.02    	.01		.5
i10  	+  	. 	  .      .   	    .       	.     	. 		. 
i10  	+  	.26667  .      5.03	    .       	.     	. 		. 
i10  	+  	.26667  .      .	          .       	.     	. 		. 
i10  	+  	.26667  .      .   	    .       	.     	. 		. 

i10  	+  	.4   	  .      5.02	    .       	.     	. 		.
i10  	+  	. 	  .      .   	    .       	.     	. 		. 
i10  	+  	. 	  .      .   	    .       	.     	. 		. 
i10  	+  	. 	  .      5.12   	    .       	.     	. 		. 

;12


i10  	+  	.4 	  .      6.02	    .       	.02    	.01		.5
i10  	+  	. 	  .      5.02   	    .       	.     	. 		. 
i10  	+  	.26667  .      5.03	    .       	.     	. 		. 
i10  	+  	.26667  .      .	          .       	.     	. 		. 
i10  	+  	.26667  .      .   	    .       	.     	. 		. 

i10  	+  	.4 	  .      5.02	    .       	.     	. 		.
i10  	+  	. 	  .      .   	    .       	.     	. 		. 
i10  	+  	. 	  .      .   	    .       	.     	. 		. 
i10  	+  	.2 	  .      6.02   	    .       	.     	. 		. 
i10  	+  	.2 	  .      .   	    .       	.     	. 		. 

;14
;ends at 83.2


i10  	90    .4 	  9500   5.02	    .01      	.02    	.01		.5
i10  	+  	. 	  .      5.02   	    .       	.     	. 		. 
i10  	+  	.26667  .      5.03	    .       	.     	. 		. 
i10  	+  	.26667  .      .	          .       	.     	. 		. 
i10  	+  	.26667  .      .   	    .       	.     	. 		. 

i10  	+  	.4 	  .      5.02	    .       	.     	. 		.
i10  	+  	. 	  .      .   	    .       	.     	. 		. 
i10  	+  	. 	  .      .   	    .       	.     	. 		. 
i10  	+  	.4 	  .      6.02   	    .       	.     	. 		. 

i10  	+  	.4 	  .      5.02	    .       	.02    	.01		.5
i10  	+  	. 	  .      .   	    .       	.     	. 		. 
i10  	+  	.26667  .      5.03	    .       	.     	. 		. 
i10  	+  	.26667  .      .	          .       	.     	. 		. 
i10  	+  	.26667  .      .   	    .       	.     	. 		. 

i10  	+  	.4   	  .      5.02	    .       	.     	. 		.
i10  	+  	. 	  .      .   	    .       	.     	. 		. 
i10  	+  	. 	  .      .   	    .       	.     	. 		. 
i10  	+  	. 	  .      5.12   	    .       	.     	. 		. 

i10  	+     .4 	  9500   5.02	    .01      	.02    	.01		.5
i10  	+  	. 	  .      5.02   	    .       	.     	. 		. 
i10  	+  	.26667  .      5.03	    .       	.     	. 		. 
i10  	+  	.26667  .      .	          .       	.     	. 		. 
i10  	+  	.26667  .      .   	    .       	.     	. 		. 

i10  	+  	.4 	  .      5.02	    .       	.     	. 		.
i10  	+  	. 	  .      .   	    .       	.     	. 		. 
i10  	+  	. 	  .      .   	    .       	.     	. 		. 
i10  	+  	.4 	  .      6.02   	    .       	.     	. 		. 

i10  	+  	.4 	  .      5.02	    .       	.02    	.01		.5
i10  	+  	. 	  .      .   	    .       	.     	. 		. 
i10  	+  	.26667  .      5.03	    .       	.     	. 		. 
i10  	+  	.26667  .      .	          .       	.     	. 		. 
i10  	+  	.26667  .      .   	    .       	.     	. 		. 

i10  	+  	.4   	  .      5.02	    .       	.     	. 		.
i10  	+  	. 	  .      .   	    .       	.     	. 		. 
i10  	+  	. 	  .      .   	    .       	.     	. 		. 
i10  	+  	. 	  .      5.12   	    .       	.     	. 		. 

;8


i10  	+    .4 	  9500   5.02	    .01      	.02    	.01		.5
i10  	+  	. 	  .      5.02   	    .       	.     	. 		. 
i10  	+  	.26667  .      5.03	    .       	.     	. 		. 
i10  	+  	.26667  .      .	          .       	.     	. 		. 
i10  	+  	.26667  .      .   	    .       	.     	. 		. 

i10  	+  	.4 	  .      5.02	    .       	.     	. 		.
i10  	+  	. 	  .      .   	    .       	.     	. 		. 
i10  	+  	. 	  .      .   	    .       	.     	. 		. 
i10  	+  	.4 	  .      6.02   	    .       	.     	. 		. 

i10  	+  	.4 	  .      5.02	    .       	.02    	.01		.5
i10  	+  	. 	  .      .   	    .       	.     	. 		. 
i10  	+  	.26667  .      5.03	    .       	.     	. 		. 
i10  	+  	.26667  .      .	          .       	.     	. 		. 
i10  	+  	.26667  .      .   	    .       	.     	. 		. 

i10  	+  	.4   	  .      5.02	    .       	.     	. 		.
i10  	+  	. 	  .      .   	    .       	.     	. 		. 
i10  	+  	. 	  .      .   	    .       	.     	. 		. 
i10  	+  	. 	  .      5.12   	    .       	.     	. 		. 

i10  	+     .4 	  9500   5.02	    .01      	.02    	.01		.5
i10  	+  	. 	  .      5.02   	    .       	.     	. 		. 
i10  	+  	.26667  .      5.03	    .       	.     	. 		. 
i10  	+  	.26667  .      .	          .       	.     	. 		. 
i10  	+  	.26667  .      .   	    .       	.     	. 		. 

i10  	+  	.4 	  .      5.02	    .       	.     	. 		.
i10  	+  	. 	  .      .   	    .       	.     	. 		. 
i10  	+  	. 	  .      .   	    .       	.     	. 		. 
i10  	+  	.4 	  .      6.02   	    .       	.     	. 		. 

i10  	+  	.4 	  .      5.02	    .       	.02    	.01		.5
i10  	+  	. 	  .      .   	    .       	.     	. 		. 
i10  	+  	.26667  .      5.03	    .       	.     	. 		. 
i10  	+  	.26667  .      .	          .       	.     	. 		. 
i10  	+  	.26667  .      .   	    .       	.     	. 		. 

i10  	+  	.4   	  .      5.02	    .       	.     	. 		.
i10  	+  	. 	  .      .   	    .       	.     	. 		. 
i10  	+  	. 	  .      .   	    .       	.     	. 		. 
i10  	+  	. 	  .      5.12   	    .       	.     	. 		. 

;16








i10  	+    .4 	  9500   5.00	    .01      	.02    	.01		.5
i10  	+  	. 	  .      5.00   	    .       	.     	. 		. 
i10  	+  	.26667  .      5.01	    .       	.     	. 		. 
i10  	+  	.26667  .      .	          .       	.     	. 		. 
i10  	+  	.26667  .      .   	    .       	.     	. 		. 

i10  	+  	.4 	  .      5.00	    .       	.     	. 		.
i10  	+  	. 	  .      .   	    .       	.     	. 		. 
i10  	+  	. 	  .      .   	    .       	.     	. 		. 
i10  	+  	.4 	  .      6.00   	    .       	.     	. 		. 

i10  	+  	.4 	  .      5.00	    .       	.02    	.01		.5
i10  	+  	. 	  .      .  	    .       	.     	. 		. 
i10  	+  	.26667  .      5.01	    .       	.     	. 		. 
i10  	+  	.26667  .      .	          .       	.     	. 		. 
i10  	+  	.26667  .      .   	    .       	.     	. 		. 

i10  	+  	.4   	  .      5.00	    .       	.     	. 		.
i10  	+  	. 	  .      .   	    .       	.     	. 		. 
i10  	+  	. 	  .      .   	    .       	.     	. 		. 
i10  	+  	. 	  .      5.10   	    .       	.     	. 		. 

i10  	+     .4 	  9500   5.00	    .01      	.02    	.01		.5
i10  	+  	. 	  .      5.00   	    .       	.     	. 		. 
i10  	+  	.26667  .      5.01	    .       	.     	. 		. 
i10  	+  	.26667  .      .	          .       	.     	. 		. 
i10  	+  	.26667  .      .   	    .       	.     	. 		. 

i10  	+  	.4 	  .      5.00	    .       	.     	. 		.
i10  	+  	. 	  .      .   	    .       	.     	. 		. 
i10  	+  	. 	  .      .   	    .       	.     	. 		. 
i10  	+  	.4 	  .      6.00   	    .       	.     	. 		. 

i10  	+  	.4 	  .      5.00	    .       	.02    	.01		.5
i10  	+  	. 	  .      .   	    .       	.     	. 		. 
i10  	+  	.26667  .      5.01	    .       	.     	. 		. 
i10  	+  	.26667  .      .	          .       	.     	. 		. 
i10  	+  	.26667  .      .   	    .       	.     	. 		. 

i10  	+  	.4   	  .      5.00	    .       	.     	. 		.
i10  	+  	. 	  .      .   	    .       	.     	. 		. 
i10  	+  	. 	  .      .   	    .       	.     	. 		. 
i10  	+  	. 	  .      5.10   	    .       	.     	. 		. 

;8



i10  	+    .4 	  9500   5.02	    .01      	.02    	.01		.5
i10  	+  	. 	  .      5.02   	    .       	.     	. 		. 
i10  	+  	.26667  .      5.03	    .       	.     	. 		. 
i10  	+  	.26667  .      .	          .       	.     	. 		. 
i10  	+  	.26667  .      .   	    .       	.     	. 		. 

i10  	+  	.4 	  .      5.02	    .       	.     	. 		.
i10  	+  	. 	  .      .   	    .       	.     	. 		. 
i10  	+  	. 	  .      .   	    .       	.     	. 		. 
i10  	+  	.4 	  .      6.02   	    .       	.     	. 		. 

i10  	+  	.4 	  .      5.02	    .       	.02    	.01		.5
i10  	+  	. 	  .      .   	    .       	.     	. 		. 
i10  	+  	.26667  .      5.03	    .       	.     	. 		. 
i10  	+  	.26667  .      .	          .       	.     	. 		. 
i10  	+  	.26667  .      .   	    .       	.     	. 		. 

i10  	+  	.4   	  .      5.02	    .       	.     	. 		.
i10  	+  	. 	  .      .   	    .       	.     	. 		. 
i10  	+  	. 	  .      .   	    .       	.     	. 		. 
i10  	+  	. 	  .      5.12   	    .       	.     	. 		. 

i10  	+     .4 	  9500   5.02	    .01      	.02    	.01		.5
i10  	+  	. 	  .      5.02   	    .       	.     	. 		. 
i10  	+  	.26667  .      5.03	    .       	.     	. 		. 
i10  	+  	.26667  .      .	          .       	.     	. 		. 
i10  	+  	.26667  .      .   	    .       	.     	. 		. 

i10  	+  	.4 	  .      5.02	    .       	.     	. 		.
i10  	+  	. 	  .      .   	    .       	.     	. 		. 
i10  	+  	. 	  .      .   	    .       	.     	. 		. 
i10  	+  	.4 	  .      6.02   	    .       	.     	. 		. 

i10  	+  	.4 	  .      5.02	    .       	.02    	.01		.5
i10  	+  	. 	  .      .   	    .       	.     	. 		. 
i10  	+  	.26667  .      5.03	    .       	.     	. 		. 
i10  	+  	.26667  .      .	          .       	.     	. 		. 
i10  	+  	.26667  .      .   	    .       	.     	. 		. 

i10  	+  	.4   	  .      5.02	    .       	.     	. 		.
i10  	+  	. 	  .      .   	    .       	.     	. 		. 
i10  	+  	. 	  .      .   	    .       	.     	. 		. 
i10  	+  	. 	  .      5.12   	    .       	.     	. 		. 

;8




i10  	+    .4 	  9500   5.00	    .01      	.02    	.01		.5
i10  	+  	. 	  .      5.00   	    .       	.     	. 		. 
i10  	+  	.26667  .      5.01	    .       	.     	. 		. 
i10  	+  	.26667  .      .	          .       	.     	. 		. 
i10  	+  	.26667  .      .   	    .       	.     	. 		. 

i10  	+  	.4 	  .      5.00	    .       	.     	. 		.
i10  	+  	. 	  .      .   	    .       	.     	. 		. 
i10  	+  	. 	  .      .   	    .       	.     	. 		. 
i10  	+  	.4 	  .      6.00   	    .       	.     	. 		. 

i10  	+  	.4 	  .      5.00	    .       	.02    	.01		.5
i10  	+  	. 	  .      .  	    .       	.     	. 		. 
i10  	+  	.26667  .      5.01	    .       	.     	. 		. 
i10  	+  	.26667  .      .	          .       	.     	. 		. 
i10  	+  	.26667  .      .   	    .       	.     	. 		. 

i10  	+  	.4   	  .      5.00	    .       	.     	. 		.
i10  	+  	. 	  .      .   	    .       	.     	. 		. 
i10  	+  	. 	  .      .   	    .       	.     	. 		. 
i10  	+  	. 	  .      5.10   	    .       	.     	. 		. 

i10  	+     .4 	  9500   5.00	    .01      	.02    	.01		.5
i10  	+  	. 	  .      5.00   	    .       	.     	. 		. 
i10  	+  	.26667  .      5.01	    .       	.     	. 		. 
i10  	+  	.26667  .      .	          .       	.     	. 		. 
i10  	+  	.26667  .      .   	    .       	.     	. 		. 

i10  	+  	.4 	  .      5.00	    .       	.     	. 		.
i10  	+  	. 	  .      .   	    .       	.     	. 		. 
i10  	+  	. 	  .      .   	    .       	.     	. 		. 
i10  	+  	.4 	  .      6.00   	    .       	.     	. 		. 

i10  	+  	.4 	  .      5.00	    .       	.02    	.01		.5
i10  	+  	. 	  .      .   	    .       	.     	. 		. 
i10  	+  	.26667  .      5.01	    .       	.     	. 		. 
i10  	+  	.26667  .      .	          .       	.     	. 		. 
i10  	+  	.26667  .      .   	    .       	.     	. 		. 

i10  	+  	.4   	  9000      5.00	    .       	.     	. 		.
i10  	+  	. 	  <      .   	    .       	.     	. 		. 
i10  	+  	. 	  <      .   	    .       	.     	. 		. 
i10  	+  	. 	  <      5.10   	    .       	.     	. 		. 



i10  	+  	.4 	  <      5.00	    .       	.     	. 		.
i10  	+  	. 	  <      .   	    .       	.     	. 		. 
i10  	+  	. 	  <      .   	    .       	.     	. 		. 
i10  	+  	.4 	  <      6.00   	    .       	.     	. 		. 

i10  	+  	.4 	  <      5.00	    .       	.     	. 		.
i10  	+  	. 	  <      .   	    .       	.     	. 		. 
i10  	+  	. 	  <      .   	    .       	.     	. 		. 
i10  	+  	.4 	  100      6.00   	    .       	.     	. 		. 





; Soft OSCIL/fof instrument, PAD
;	strt	p3:dur p4:amp p5:pitch p6:reverb p7:att p8:rel p9:bal
i3  	0  	60.8 	 3200	  7.00	    .1	4	2	.1
i3  	0  	. 	 .	  7.03	    .1	.	.	.9
i3  	0  	. 	 .	  7.07	    .1	.	.	.5
i3  	0  	. 	 .	  7.10	    .1	.	.	.2


i3  	60.8  22.4 	 3200	  7.02	    .1	.1	2	.1
i3  	.  	. 	 .	  7.05	    .1	.	.	.9
i3  	.  	. 	 .	  7.09	    .1	.	.	.5
i3  	.  	. 	 .	  7.12	    .1	.	.	.2

i3  	64    1.6 	 5200	  8.02	    .05	.1	.5	.6
i3  	+     1.2 	 .	  8.00	    .05	.1	.5	.6
i3  	+     .4 	 .	  7.10	    .05	.1	.5	.4
i3  	+     2.0 	 .	  7.09	    .05	.1	.5	.2

i3  	102.8 12.8 	 3200	  7.02	    .1	6.4	2	.1
i3  	.  	. 	 .	  7.05	    .1	.	.	.9
i3  	.  	. 	 .	  7.09	    .1	.	.	.5
i3  	.  	. 	 .	  7.12	    .1	.	.	.2

i3  	115.6 12.8 	 3000	  7.00	    .1	1.6	2	.1
i3  	.  	. 	 .	  7.03	    .1	.	.	.9
i3  	.  	. 	 .	  7.07	    .1	.	.	.5
i3  	.  	. 	 .	  7.10	    .1	.	.	.2

i3  	128.4 12.8 	 3200	  7.02	    .1	.2	2	.1
i3  	.  	. 	 .	  7.05	    .1	.	.	.9
i3  	.  	. 	 .	  7.09	    .1	.	.	.5
i3  	.  	. 	 .	  7.12	    .1	.	.	.2

i3  	141.2 16 	 3000	  7.00	    .1	1.6	2	.1
i3  	.  	. 	 .	  7.03	    .1	.	.	.9
i3  	.  	. 	 .	  7.07	    .1	.	.	.5
i3  	.  	. 	 .	  7.10	    .1	.	.	.2


i3  	157.2 8 	 3300	  7.00	    .1	1.6	2	.1
i3  	.  	. 	 .	  7.04	    .1	.	.	.9
i3  	.  	. 	 .	  7.07	    .1	.	.	.5
i3  	.  	. 	 .	  7.10	    .1	.	.	.2
i3  	.  	. 	 .	  6.04	    .1	.	.	.9
i3  	.  	. 	 .	  8.04	    .1	.	.	.9




;High seq blipp
;	strt	p3:dur p4:amp p5:pitch 	    p6:reverb 	p7:att 	p8:rel 	p9:bal

i10  	70.8  .1 	  7000   10.02	    .01      	.02    	.01		.8
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .0     .  	    .01      	.02    	.01		<
i10  	+     .2 	  7000   .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  7000   .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .0     .  	    .01      	.02    	.01		<
i10  	+     .4 	  7000   .  	    .01      	.02    	.01		.3

i10  	+     .1 	  7000   10.02	    .01      	.02    	.01		.8
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .0     .  	    .01      	.02    	.01		<
i10  	+     .2 	  7000   .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  7000   .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .0     .  	    .01      	.02    	.01		<
i10  	+     .4 	  7000   .  	    .01      	.02    	.01		.3

i10  	+     .1 	  7000   10.02	    .01      	.02    	.01		.8
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .0     .  	    .01      	.02    	.01		<
i10  	+     .2 	  7000   .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  7000   .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .0     .  	    .01      	.02    	.01		<
i10  	+     .4 	  7000   .  	    .01      	.02    	.01		.3

i10  	+     .1 	  7000   10.02	    .01      	.02    	.01		.8
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .0     .  	    .01      	.02    	.01		<
i10  	+     .2 	  7000   .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  7000   .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .0     .  	    .01      	.02    	.01		<
i10  	+     .4 	  7000   .  	    .01      	.02    	.01		.3

i10  	+     .1 	  7000   10.02	    .01      	.02    	.01		.8
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .0     .  	    .01      	.02    	.01		<
i10  	+     .2 	  7000   .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  7000   .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .0     .  	    .01      	.02    	.01		<
i10  	+     .4 	  7000   .  	    .01      	.02    	.01		.3

i10  	+     .1 	  7000   10.02	    .01      	.02    	.01		.8
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .0     .  	    .01      	.02    	.01		<
i10  	+     .2 	  7000   .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  7000   .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .0     .  	    .01      	.02    	.01		<
i10  	+     .4 	  7000   .  	    .01      	.02    	.01		.3

i10  	+     .1 	  7000   10.02	    .01      	.02    	.01		.8
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .0     .  	    .01      	.02    	.01		<
i10  	+     .2 	  7000   .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  7000   .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .0     .  	    .01      	.02    	.01		<
i10  	+     .4 	  7000   .  	    .01      	.02    	.01		.3

i10  	+     .1 	  7000   .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .0     .  	    .01      	.02    	.01		<
i10  	+     .4 	  7000   .  	    .01      	.02    	.01		.3





;==========================================================================================


; Glissando
i10  	80     .1 	  9000   12.02  	    .0      	.02    	.01		0
i10  	+      . 	  .      12.01  	    <       	.     	. 		<
i10  	+      . 	  .      12.00  	    <       	.     	. 		<
i10  	+      . 	  .      11.11  	    <       	.     	. 		<
i10  	+      . 	  .      11.10  	    <       	.     	. 		<
i10  	+      . 	  .      11.09  	    <       	.     	. 		<
i10  	+      . 	  .      11.08  	    <       	.     	. 		<
i10  	+      . 	  .      11.07  	    <       	.     	. 		<
i10  	+      . 	  .      11.06  	    <       	.     	. 		<
i10  	+      . 	  .      11.05  	    <       	.     	. 		<
i10  	+      . 	  .      11.04  	    <       	.     	. 		<
i10  	+      . 	  .      11.03  	    <       	.     	. 		<
i10  	+      . 	  .      11.02  	    <       	.     	. 		<
i10  	+      . 	  .      11.01  	    <       	.     	. 		<
i10  	+      . 	  .      11.0  	    <       	.     	. 		<
i10  	+      . 	  .       10.11  	    <       	.     	. 		<
i10  	+      . 	  .       10.10  	    <       	.     	. 		<
i10  	+      . 	  .       10.09  	    <       	.     	. 		<
i10  	+      . 	  .       10.08  	    <       	.     	. 		<
i10  	+      . 	  .       10.07  	    <       	.     	. 		<
i10  	+      . 	  .       10.06  	    <       	.     	. 		<
i10  	+      . 	  .       10.05  	    <       	.     	. 		<
i10  	+      . 	  .       10.04  	    <       	.     	. 		<
i10  	+      . 	  .       10.03  	    <       	.     	. 		<
i10  	+      . 	  .       10.02  	    <       	.     	. 		<
i10  	+      . 	  .       10.01  	    <       	.     	. 		<
i10  	+      . 	  .       10.00  	    <       	.     	. 		<
i10  	+      . 	  .       9.11  	    <       	.     	. 		<
i10  	+      . 	  .       9.10  	    <       	.     	. 		<
i10  	+      . 	  .       9.09  	    <        	.     	. 		<
i10  	+      . 	  .       9.08  	    <           	.     	. 		<
i10  	+      . 	  .       9.07  	    .2       	.     	. 		1

;ends at 83.2


i10  	112.4     .1 	  9000   12.02  	    .0      	.02    	.01		0
i10  	+      . 	  .      12.01  	    <       	.     	. 		<
i10  	+      . 	  .      12.00  	    <       	.     	. 		<
i10  	+      . 	  .      11.11  	    <       	.     	. 		<
i10  	+      . 	  .      11.10  	    <       	.     	. 		<
i10  	+      . 	  .      11.09  	    <       	.     	. 		<
i10  	+      . 	  .      11.08  	    <       	.     	. 		<
i10  	+      . 	  .      11.07  	    <       	.     	. 		<
i10  	+      . 	  .      11.06  	    <       	.     	. 		<
i10  	+      . 	  .      11.05  	    <       	.     	. 		<
i10  	+      . 	  .      11.04  	    <       	.     	. 		<
i10  	+      . 	  .      11.03  	    <       	.     	. 		<
i10  	+      . 	  .      11.02  	    <       	.     	. 		<
i10  	+      . 	  .      11.01  	    <       	.     	. 		<
i10  	+      . 	  .      11.0  	    <       	.     	. 		<
i10  	+      . 	  .       10.11  	    <       	.     	. 		<
i10  	+      . 	  .       10.10  	    <       	.     	. 		<
i10  	+      . 	  .       10.09  	    <       	.     	. 		<
i10  	+      . 	  .       10.08  	    <       	.     	. 		<
i10  	+      . 	  .       10.07  	    <       	.     	. 		<
i10  	+      . 	  .       10.06  	    <       	.     	. 		<
i10  	+      . 	  .       10.05  	    <       	.     	. 		<
i10  	+      . 	  .       10.04  	    <       	.     	. 		<
i10  	+      . 	  .       10.03  	    <       	.     	. 		<
i10  	+      . 	  .       10.02  	    <       	.     	. 		<
i10  	+      . 	  .       10.01  	    <       	.     	. 		<
i10  	+      . 	  .       10.00  	    <       	.     	. 		<
i10  	+      . 	  .       9.11  	    <       	.     	. 		<
i10  	+      . 	  .       9.10  	    <       	.     	. 		<
i10  	+      . 	  .       9.09  	    <        	.     	. 		<
i10  	+      . 	  .       9.08  	    <           	.     	. 		<
i10  	+      . 	  .       9.07  	    .2       	.     	. 		1


i10  	138  .1 	  9000   12.02  	    .0      	.02    	.01		0
i10  	+      . 	  .      12.01  	    <       	.     	. 		<
i10  	+      . 	  .      12.00  	    <       	.     	. 		<
i10  	+      . 	  .      11.11  	    <       	.     	. 		<
i10  	+      . 	  .      11.10  	    <       	.     	. 		<
i10  	+      . 	  .      11.09  	    <       	.     	. 		<
i10  	+      . 	  .      11.08  	    <       	.     	. 		<
i10  	+      . 	  .      11.07  	    <       	.     	. 		<
i10  	+      . 	  .      11.06  	    <       	.     	. 		<
i10  	+      . 	  .      11.05  	    <       	.     	. 		<
i10  	+      . 	  .      11.04  	    <       	.     	. 		<
i10  	+      . 	  .      11.03  	    <       	.     	. 		<
i10  	+      . 	  .      11.02  	    <       	.     	. 		<
i10  	+      . 	  .      11.01  	    <       	.     	. 		<
i10  	+      . 	  .      11.0  	    <       	.     	. 		<
i10  	+      . 	  .       10.11  	    <       	.     	. 		<
i10  	+      . 	  .       10.10  	    <       	.     	. 		<
i10  	+      . 	  .       10.09  	    <       	.     	. 		<
i10  	+      . 	  .       10.08  	    <       	.     	. 		<
i10  	+      . 	  .       10.07  	    <       	.     	. 		<
i10  	+      . 	  .       10.06  	    <       	.     	. 		<
i10  	+      . 	  .       10.05  	    <       	.     	. 		<
i10  	+      . 	  .       10.04  	    <       	.     	. 		<
i10  	+      . 	  .       10.03  	    <       	.     	. 		<
i10  	+      . 	  .       10.02  	    <       	.     	. 		<
i10  	+      . 	  .       10.01  	    <       	.     	. 		<
i10  	+      . 	  .       10.00  	    <       	.     	. 		<
i10  	+      . 	  .       9.11  	    <       	.     	. 		<
i10  	+      . 	  .       9.10  	    <       	.     	. 		<
i10  	+      . 	  .       9.09  	    <        	.     	. 		<
i10  	+      . 	  .       9.08  	    <           	.     	. 		<
i10  	+      . 	  .       9.07  	    .2       	.     	. 		1


i10  	154    .1 	  9000   12.02  	    .0      	.02    	.01		0
i10  	+      . 	  .      12.01  	    <       	.     	. 		<
i10  	+      . 	  .      12.00  	    <       	.     	. 		<
i10  	+      . 	  .      11.11  	    <       	.     	. 		<
i10  	+      . 	  .      11.10  	    <       	.     	. 		<
i10  	+      . 	  .      11.09  	    <       	.     	. 		<
i10  	+      . 	  .      11.08  	    <       	.     	. 		<
i10  	+      . 	  .      11.07  	    <       	.     	. 		<
i10  	+      . 	  .      11.06  	    <       	.     	. 		<
i10  	+      . 	  .      11.05  	    <       	.     	. 		<
i10  	+      . 	  .      11.04  	    <       	.     	. 		<
i10  	+      . 	  .      11.03  	    <       	.     	. 		<
i10  	+      . 	  .      11.02  	    <       	.     	. 		<
i10  	+      . 	  .      11.01  	    <       	.     	. 		<
i10  	+      . 	  .      11.0  	    <       	.     	. 		<
i10  	+      . 	  .       10.11  	    <       	.     	. 		<
i10  	+      . 	  .       10.10  	    <       	.     	. 		<
i10  	+      . 	  .       10.09  	    <       	.     	. 		<
i10  	+      . 	  .       10.08  	    <       	.     	. 		<
i10  	+      . 	  .       10.07  	    <       	.     	. 		<
i10  	+      . 	  .       10.06  	    <       	.     	. 		<
i10  	+      . 	  .       10.05  	    <       	.     	. 		<
i10  	+      . 	  .       10.04  	    <       	.     	. 		<
i10  	+      . 	  .       10.03  	    <       	.     	. 		<
i10  	+      . 	  .       10.02  	    <       	.     	. 		<
i10  	+      . 	  .       10.01  	    <       	.     	. 		<
i10  	+      . 	  .       10.00  	    <       	.     	. 		<
i10  	+      . 	  .       9.11  	    <       	.     	. 		<
i10  	+      . 	  .       9.10  	    <       	.     	. 		<
i10  	+      . 	  .       9.09  	    <        	.     	. 		<
i10  	+      . 	  .       9.08  	    <           	.     	. 		<
i10  	+      . 	  .       9.07  	    .2       	.     	. 		1

;=======================================================================================-



i10  	90    .1 	  7000   10.02	    .01      	.02    	.01		.8
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .0     .  	    .01      	.02    	.01		<
i10  	+     .2 	  7000   .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  7000   .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .0     .  	    .01      	.02    	.01		<
i10  	+     .4 	  7000   .  	    .01      	.02    	.01		.3

i10  	+     .1 	  7000   10.02	    .01      	.02    	.01		.8
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .0     .  	    .01      	.02    	.01		<
i10  	+     .2 	  7000   .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  7000   .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .0     .  	    .01      	.02    	.01		<
i10  	+     .4 	  7000   .  	    .01      	.02    	.01		.3

i10  	+     .1 	  7000   10.02	    .01      	.02    	.01		.8
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .0     .  	    .01      	.02    	.01		<
i10  	+     .2 	  7000   .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  7000   .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .0     .  	    .01      	.02    	.01		<
i10  	+     .4 	  7000   .  	    .01      	.02    	.01		.3

i10  	+     .1 	  7000   10.02	    .01      	.02    	.01		.8
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .0     .  	    .01      	.02    	.01		<
i10  	+     .2 	  7000   .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  7000   .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .0     .  	    .01      	.02    	.01		<
i10  	+     .4 	  7000   .  	    .01      	.02    	.01		.3

i10  	+     .1 	  7000   10.02	    .01      	.02    	.01		.8
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .0     .  	    .01      	.02    	.01		<
i10  	+     .2 	  7000   .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  7000   .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .0     .  	    .01      	.02    	.01		<
i10  	+     .4 	  7000   .  	    .01      	.02    	.01		.3

i10  	+     .1 	  7000   10.02	    .01      	.02    	.01		.8
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .0     .  	    .01      	.02    	.01		<
i10  	+     .2 	  7000   .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  7000   .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .0     .  	    .01      	.02    	.01		<
i10  	+     .4 	  7000   .  	    .01      	.02    	.01		.3

i10  	+     .1 	  7000   10.02	    .01      	.02    	.01		.8
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .0     .  	    .01      	.02    	.01		<
i10  	+     .2 	  7000   .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  7000   .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .0     .  	    .01      	.02    	.01		<
i10  	+     .4 	  7000   .  	    .01      	.02    	.01		.3

i10  	+     .1 	  7000   10.02	    .01      	.02    	.01		.8
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .0     .  	    .01      	.02    	.01		<
i10  	+     .2 	  7000   .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  7000   .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .0     .  	    .01      	.02    	.01		<
i10  	+     .4 	  7000   .  	    .01      	.02    	.01		.3

;8

i10  	+    .1 	  7000   10.02	    .01      	.02    	.01		.8
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .0     .  	    .01      	.02    	.01		<
i10  	+     .2 	  7000   .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  7000   .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .0     .  	    .01      	.02    	.01		<
i10  	+     .4 	  7000   .  	    .01      	.02    	.01		.3

i10  	+     .1 	  7000   10.02	    .01      	.02    	.01		.8
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .0     .  	    .01      	.02    	.01		<
i10  	+     .2 	  7000   .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  7000   .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .0     .  	    .01      	.02    	.01		<
i10  	+     .4 	  7000   .  	    .01      	.02    	.01		.3

i10  	+     .1 	  7000   10.02	    .01      	.02    	.01		.8
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .0     .  	    .01      	.02    	.01		<
i10  	+     .2 	  7000   .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  7000   .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .0     .  	    .01      	.02    	.01		<
i10  	+     .4 	  7000   .  	    .01      	.02    	.01		.3

i10  	+     .1 	  7000   10.02	    .01      	.02    	.01		.8
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .0     .  	    .01      	.02    	.01		<
i10  	+     .2 	  7000   .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  7000   .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .0     .  	    .01      	.02    	.01		<
i10  	+     .4 	  7000   .  	    .01      	.02    	.01		.3

i10  	+     .1 	  7000   10.02	    .01      	.02    	.01		.8
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .0     .  	    .01      	.02    	.01		<
i10  	+     .2 	  7000   .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  7000   .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .0     .  	    .01      	.02    	.01		<
i10  	+     .4 	  7000   .  	    .01      	.02    	.01		.3

i10  	+     .1 	  7000   10.02	    .01      	.02    	.01		.8
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .0     .  	    .01      	.02    	.01		<
i10  	+     .2 	  7000   .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  7000   .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .0     .  	    .01      	.02    	.01		<
i10  	+     .4 	  7000   .  	    .01      	.02    	.01		.3

i10  	+     .1 	  7000   10.02	    .01      	.02    	.01		.8
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .0     .  	    .01      	.02    	.01		<
i10  	+     .2 	  7000   .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  7000   .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .0     .  	    .01      	.02    	.01		<
i10  	+     .4 	  7000   .  	    .01      	.02    	.01		.3

i10  	+     .1 	  7000   10.02	    .01      	.02    	.01		.8
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .0     .  	    .01      	.02    	.01		<
i10  	+     .2 	  7000   .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  7000   .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .0     .  	    .01      	.02    	.01		<
i10  	+     .4 	  7000   .  	    .01      	.02    	.01		.3

;16






i10  	+     .1 	  7000   10.00	    .01      	.02    	.01		.8
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .0     .  	    .01      	.02    	.01		<
i10  	+     .2 	  7000   .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  7000   .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .0     .  	    .01      	.02    	.01		<
i10  	+     .4 	  7000   .  	    .01      	.02    	.01		.3

i10  	+     .1 	  7000   .   	    .01      	.02    	.01		.8
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .0     .  	    .01      	.02    	.01		<
i10  	+     .2 	  7000   .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  7000   .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .0     .  	    .01      	.02    	.01		<
i10  	+     .4 	  7000   .  	    .01      	.02    	.01		.3

i10  	+     .1 	  7000   .  	    .01      	.02    	.01		.8
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .0     .  	    .01      	.02    	.01		<
i10  	+     .2 	  7000   .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  7000   .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .0     .  	    .01      	.02    	.01		<
i10  	+     .4 	  7000   .  	    .01      	.02    	.01		.3

i10  	+     .1 	  7000   .  	    .01      	.02    	.01		.8
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .0     .  	    .01      	.02    	.01		<
i10  	+     .2 	  7000   .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  7000   .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .0     .  	    .01      	.02    	.01		<
i10  	+     .4 	  7000   .  	    .01      	.02    	.01		.3

i10  	+     .1 	  7000   .  	    .01      	.02    	.01		.8
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .0     .  	    .01      	.02    	.01		<
i10  	+     .2 	  7000   .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  7000   .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .0     .  	    .01      	.02    	.01		<
i10  	+     .4 	  7000   .  	    .01      	.02    	.01		.3

i10  	+     .1 	  7000   .  	    .01      	.02    	.01		.8
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .0     .  	    .01      	.02    	.01		<
i10  	+     .2 	  7000   .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  7000   .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .0     .  	    .01      	.02    	.01		<
i10  	+     .4 	  7000   .  	    .01      	.02    	.01		.3

i10  	+     .1 	  7000   .  	    .01      	.02    	.01		.8
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .0     .  	    .01      	.02    	.01		<
i10  	+     .2 	  7000   .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  7000   .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .0     .  	    .01      	.02    	.01		<
i10  	+     .4 	  7000   .  	    .01      	.02    	.01		.3

i10  	+     .1 	  7000   .  	    .01      	.02    	.01		.8
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .0     .  	    .01      	.02    	.01		<
i10  	+     .2 	  7000   .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  7000   .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .0     .  	    .01      	.02    	.01		<
i10  	+     .4 	  7000   .  	    .01      	.02    	.01		.3

;8






i10  	+    .1 	  7000   10.02	    .01      	.02    	.01		.8
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .0     .  	    .01      	.02    	.01		<
i10  	+     .2 	  7000   .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  7000   .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .0     .  	    .01      	.02    	.01		<
i10  	+     .4 	  7000   .  	    .01      	.02    	.01		.3

i10  	+     .1 	  7000   10.02	    .01      	.02    	.01		.8
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .0     .  	    .01      	.02    	.01		<
i10  	+     .2 	  7000   .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  7000   .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .0     .  	    .01      	.02    	.01		<
i10  	+     .4 	  7000   .  	    .01      	.02    	.01		.3

i10  	+     .1 	  7000   10.02	    .01      	.02    	.01		.8
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .0     .  	    .01      	.02    	.01		<
i10  	+     .2 	  7000   .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  7000   .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .0     .  	    .01      	.02    	.01		<
i10  	+     .4 	  7000   .  	    .01      	.02    	.01		.3

i10  	+     .1 	  7000   10.02	    .01      	.02    	.01		.8
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .0     .  	    .01      	.02    	.01		<
i10  	+     .2 	  7000   .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  7000   .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .0     .  	    .01      	.02    	.01		<
i10  	+     .4 	  7000   .  	    .01      	.02    	.01		.3

i10  	+     .1 	  7000   10.02	    .01      	.02    	.01		.8
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .0     .  	    .01      	.02    	.01		<
i10  	+     .2 	  7000   .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  7000   .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .0     .  	    .01      	.02    	.01		<
i10  	+     .4 	  7000   .  	    .01      	.02    	.01		.3

i10  	+     .1 	  7000   10.02	    .01      	.02    	.01		.8
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .0     .  	    .01      	.02    	.01		<
i10  	+     .2 	  7000   .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  7000   .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .0     .  	    .01      	.02    	.01		<
i10  	+     .4 	  7000   .  	    .01      	.02    	.01		.3

i10  	+     .1 	  7000   10.02	    .01      	.02    	.01		.8
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .0     .  	    .01      	.02    	.01		<
i10  	+     .2 	  7000   .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  7000   .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .0     .  	    .01      	.02    	.01		<
i10  	+     .4 	  7000   .  	    .01      	.02    	.01		.3

i10  	+     .1 	  7000   10.02	    .01      	.02    	.01		.8
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .0     .  	    .01      	.02    	.01		<
i10  	+     .2 	  7000   .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  7000   .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .0     .  	    .01      	.02    	.01		<
i10  	+     .4 	  7000   .  	    .01      	.02    	.01		.3

;8


; 1 bar=1,6 sec



;end

i10  	+     .1 	  7000   10.00	    .01      	.02    	.01		.8
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .0     .  	    .01      	.02    	.01		<
i10  	+     .2 	  7000   .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  7000   .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .0     .  	    .01      	.02    	.01		<
i10  	+     .4 	  7000   .  	    .01      	.02    	.01		.3

i10  	+     .1 	  7000   10.00	    .01      	.02    	.01		.8
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .0     .  	    .01      	.02    	.01		<
i10  	+     .2 	  7000   .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  7000   .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .0     .  	    .01      	.02    	.01		<
i10  	+     .4 	  7000   .  	    .01      	.02    	.01		.3

i10  	+     .1 	  7000   10.00	    .01      	.02    	.01		.8
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .0     .  	    .01      	.02    	.01		<
i10  	+     .2 	  7000   .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  7000   .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .0     .  	    .01      	.02    	.01		<
i10  	+     .4 	  7000   .  	    .01      	.02    	.01		.3

i10  	+     .1 	  7000   10.00	    .01      	.02    	.01		.8
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .0     .  	    .01      	.02    	.01		<
i10  	+     .2 	  7000   .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  7000   .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .0     .  	    .01      	.02    	.01		<
i10  	+     .4 	  7000   .  	    .01      	.02    	.01		.3

i10  	+     .1 	  7000   10.00	    .01      	.02    	.01		.8
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .0     .  	    .01      	.02    	.01		<
i10  	+     .2 	  7000   .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  7000   .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .0     .  	    .01      	.02    	.01		<
i10  	+     .4 	  7000   .  	    .01      	.02    	.01		.3

i10  	+     .1 	  7000   10.00	    .01      	.02    	.01		.8
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .0     .  	    .01      	.02    	.01		<
i10  	+     .2 	  7000   .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  7000   .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .0     .  	    .01      	.02    	.01		<
i10  	+     .4 	  7000   .  	    .01      	.02    	.01		.3

i10  	+     .1 	  7000   10.00	    .01      	.02    	.01		.8
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .0     .  	    .01      	.02    	.01		<
i10  	+     .2 	  7000   .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  7000   .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .0     .  	    .01      	.02    	.01		<
i10  	+     .4 	  7000   .  	    .01      	.02    	.01		.3

i10  	+     .1 	  7000   10.00	    .01      	.02    	.01		.8
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .0     .  	    .01      	.02    	.01		<
i10  	+     .2 	  7000   .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  7000   .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .0     .  	    .01      	.02    	.01		<
i10  	+     .4 	  7000   .  	    .01      	.02    	.01		.3

i10  	+     .1 	  7000   10.00	    .01      	.02    	.01		.8
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .0     .  	    .01      	.02    	.01		<
i10  	+     .2 	  7000   .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  7000   .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .0     .  	    .01      	.02    	.01		<
i10  	+     .4 	  7000   .  	    .01      	.02    	.01		.3

i10  	+     .1 	  7000   10.00	    .01      	.02    	.01		.8
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .0     .  	    .01      	.02    	.01		<
i10  	+     .2 	  7000   .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  7000   .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .0     .  	    .01      	.02    	.01		<
i10  	+     .4 	  7000   .  	    .01      	.02    	.01		.3

i10  	+     .1 	  7000   10.00	    .01      	.02    	.01		.8
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .0     .  	    .01      	.02    	.01		<
i10  	+     .2 	  7000   .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  7000   .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .0     .  	    .01      	.02    	.01		<
i10  	+     .4 	  7000   .  	    .01      	.02    	.01		.3

i10  	+     .1 	  7000   10.00	    .01      	.02    	.01		.8
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .0     .  	    .01      	.02    	.01		<
i10  	+     .2 	  7000   .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  7000   .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .      .  	    .01      	.02    	.01		<
i10  	+     .1 	  .0     .  	    .01      	.02    	.01		<
i10  	+     .4 	  7000   .  	    .01      	.02    	.01		.3


;14





; PAN BLIPP


i3  	48    .2 	 12000  8.00  	    .1	.05	.01	0
i3  	+  	.2 	 .	  .		    .1	.01	.01	<
i3  	+  	.2 	 .	  .		    .1	.01	.01	<
i3  	+  	.2 	 .	  .		    .1	.01	.01	<
i3  	+  	.2 	 .	  .		    .1	.01	.01	<
i3  	+  	.2 	 .	  .		    .1	.01	.01	<
i3  	+  	.2 	 .	  .		    .1	.01	.01	<
i3  	+  	.2 	 .	  .   	    .1	.01	.01	<

;1

i3  	+  	.2 	 .	  .   	    .1	.01	.01	<
i3  	+  	.2 	 .	  .   	    .1	.01	.01	<
i3  	+  	.2 	 .	  .   	    .1	.01	.01	<
i3  	+  	.2 	 .	  .   	    .1	.01	.01	<
i3  	+  	.2 	 .	  .   	    .1	.01	.01	<
i3  	+  	.2 	 .	  .    	    .1	.01	.01	<
i3  	+  	.2 	 .	  .   	    .1	.01	.01	<
i3  	+  	.2 	 .	  .   	    .1	.01	.01	1

;2

i3  	+  	.1 	 .	  8.03	    .0	.01	.01	1
i3  	+  	.1 	 .	  .   	    .0	.01	.01	<
i3  	+  	.1 	 .	  .   	    .0	.01	.01	<
i3  	+  	.1 	 .	  .   	    .0	.01	.01	<
i3  	+  	.1 	 .	  .   	    .0	.01	.01	<
i3  	+  	.1 	 .	  .   	    .0	.01	.01	<
i3  	+  	.1 	 .	  .   	    .0	.01	.01	<
i3  	+  	.1 	 .	  .   	    .0	.01	.01	0
i3  	+  	.1 	 .	  .   	    .0	.01	.01	1
i3  	+  	.1 	 .	  .    	    .0	.01	.01	<
i3  	+  	.1 	 .	  .    	    .0	.01	.01	<
i3  	+  	.1 	 .	  .   	    .0	.01	.01	<
i3  	+  	.1 	 .	  .   	    .0	.01	.01	<
i3  	+  	.1 	 .	  .   	    .0	.01	.01	<
i3  	+  	.1 	 .	  .   	    .0	.01	.01	<
i3  	+  	.1 	 .	  .   	    .0	.01	.01	0

;3

i3  	+  	.1 	 .	  .   	    .0	.01	.01	1
i3  	+  	.1 	 .	  .   	    .0	.01	.01	<
i3  	+  	.1 	 .	  .   	    .0	.01	.01	<
i3  	+  	.1 	 .	  .   	    .0	.01	.01	<
i3  	+  	.1 	 .	  .   	    .0	.01	.01	<
i3  	+  	.1 	 .	  .    	    .0	.01	.01	<
i3  	+  	.1 	 .	  .   	    .0	.01	.01	<
i3  	+  	.1 	 .	  .   	    .0	.01	.01	0
i3  	+  	.1 	 .	  .   	    .0	.01	.01	1
i3  	+  	.1 	 .	  .   	    .0	.01	.01	<
i3  	+  	.1 	 .	  .   	    .0	.01	.01	<
i3  	+  	.1 	 .	  .   	    .0	.01	.01	<
i3  	+  	.1 	 .	  .   	    .0	.01	.01	<
i3  	+  	.1 	 .	  .    	    .0	.01	.01	<
i3  	+  	.1 	 .	  .   	    .0	.01	.01	<
i3  	+  	.1 	 .	  .   	    .0	.01	.01	0

;4

i3  	+     .2 	 .      8.00	    .1	.01	.01	0
i3  	+  	.2 	 .	  .	          .1	.01	.01	<
i3  	+  	.2 	 .	  .	          .1	.01	.01	<
i3  	+  	.2 	 .	  .    	    .1	.01	.01	<
i3  	+  	.2 	 .	  .    	    .1	.01	.01	<
i3  	+  	.2 	 .	  .    	    .1	.01	.01	<
i3  	+  	.2 	 .	  .    	    .1	.01	.01	<
i3  	+  	.2 	 .	  .    	    .1	.01	.01	<

;5

i3  	+  	.2 	 .	  .    	    .1	.01	.01	<
i3  	+  	.2 	 .	  .   	    .1	.01	.01	<
i3  	+  	.2 	 .	  .   	    .1	.01	.01	<
i3  	+  	.2 	 .	  .   	    .1	.01	.01	<
i3  	+  	.2 	 .	  .   	    .1	.01	.01	<
i3  	+  	.2 	 .	  .   	    .1	.01	.01	<
i3  	+  	.2 	 .	  .   	    .1	.01	.01	<
i3  	+  	.2 	 .	  .   	    .1	.01	.01	1

;6

i3  	+  	.1 	 .	  8.03	    .0	.01	.01	1
i3  	+  	.1 	 .	  .    	    .0	.01	.01	<
i3  	+  	.1 	 .	  .   	    .0	.01	.01	<
i3  	+  	.1 	 .	  .   	    .0	.01	.01	<
i3  	+  	.1 	 .	  .   	    .0	.01	.01	<
i3  	+  	.1 	 .	  .    	    .0	.01	.01	<
i3  	+  	.1 	 .	  .   	    .0	.01	.01	<
i3  	+  	.1 	 .	  .   	    .0	.01	.01	0
i3  	+  	.1 	 .	  8.03	    .0	.01	.01	1
i3  	+  	.1 	 .	  .    	    .0	.01	.01	<
i3  	+  	.1 	 .	  .   	    .0	.01	.01	<
i3  	+  	.1 	 .	  .   	    .0	.01	.01	<
i3  	+  	.1 	 .	  .   	    .0	.01	.01	<
i3  	+  	.1 	 .	  .    	    .0	.01	.01	<
i3  	+  	.1 	 .	  .   	    .0	.01	.01	<
i3  	+  	.1 	 .	  .   	    .0	.01	.01	0

;7

i3  	+  	.1 	 .	  8.03	    .0	.01	.01	1
i3  	+  	.1 	 .	  .    	    .0	.01	.01	<
i3  	+  	.1 	 .	  .   	    .0	.01	.01	<
i3  	+  	.1 	 .	  .   	    .0	.01	.01	<
i3  	+  	.1 	 .	  .   	    .0	.01	.01	<
i3  	+  	.1 	 .	  .    	    .0	.01	.01	<
i3  	+  	.1 	 .	  .   	    .0	.01	.01	<
i3  	+  	.1 	 .	  .   	    .0	.01	.01	0
i3  	+  	.1 	 .	  8.03	    .0	.01	.01	1
i3  	+  	.1 	 .	  .    	    .0	.01	.01	<
i3  	+  	.1 	 .	  .   	    .0	.01	.01	<
i3  	+  	.1 	 .	  .   	    .0	.01	.01	<
i3  	+  	.1 	 .	  .   	    .0	.01	.01	<
i3  	+  	.1 	 .	  .    	    .0	.01	.01	<
i3  	+  	.1 	 .	  .   	    .0	.01	.01	<
i3  	+  	.1 	 .	  .   	    .0	.01	.01	0

;8bar = 12.8 sec section ends at 60.8










i3  	115.6 .2 	 9000  8.00  	    .1	.05	.01	0
i3  	+  	.2 	 .	  .		    .1	.01	.01	<
i3  	+  	.2 	 .	  .		    .1	.01	.01	<
i3  	+  	.2 	 .	  .		    .1	.01	.01	<
i3  	+  	.2 	 .	  .		    .1	.01	.01	<
i3  	+  	.2 	 .	  .		    .1	.01	.01	<
i3  	+  	.2 	 .	  .		    .1	.01	.01	<
i3  	+  	.2 	 .	  .   	    .1	.01	.01	<

;1

i3  	+  	.2 	 .	  .   	    .1	.01	.01	<
i3  	+  	.2 	 .	  .   	    .1	.01	.01	<
i3  	+  	.2 	 .	  .   	    .1	.01	.01	<
i3  	+  	.2 	 .	  .   	    .1	.01	.01	<
i3  	+  	.2 	 .	  .   	    .1	.01	.01	<
i3  	+  	.2 	 .	  .    	    .1	.01	.01	<
i3  	+  	.2 	 .	  .   	    .1	.01	.01	<
i3  	+  	.2 	 .	  .   	    .1	.01	.01	1

;2

i3  	+  	.1 	 .	  8.03	    .0	.01	.01	1
i3  	+  	.1 	 .	  .   	    .0	.01	.01	<
i3  	+  	.1 	 .	  .   	    .0	.01	.01	<
i3  	+  	.1 	 .	  .   	    .0	.01	.01	<
i3  	+  	.1 	 .	  .   	    .0	.01	.01	<
i3  	+  	.1 	 .	  .   	    .0	.01	.01	<
i3  	+  	.1 	 .	  .   	    .0	.01	.01	<
i3  	+  	.1 	 .	  .   	    .0	.01	.01	0
i3  	+  	.1 	 .	  .   	    .0	.01	.01	1
i3  	+  	.1 	 .	  .    	    .0	.01	.01	<
i3  	+  	.1 	 .	  .    	    .0	.01	.01	<
i3  	+  	.1 	 .	  .   	    .0	.01	.01	<
i3  	+  	.1 	 .	  .   	    .0	.01	.01	<
i3  	+  	.1 	 .	  .   	    .0	.01	.01	<
i3  	+  	.1 	 .	  .   	    .0	.01	.01	<
i3  	+  	.1 	 .	  .   	    .0	.01	.01	0

;3

i3  	+  	.1 	 .	  .   	    .0	.01	.01	1
i3  	+  	.1 	 .	  .   	    .0	.01	.01	<
i3  	+  	.1 	 .	  .   	    .0	.01	.01	<
i3  	+  	.1 	 .	  .   	    .0	.01	.01	<
i3  	+  	.1 	 .	  .   	    .0	.01	.01	<
i3  	+  	.1 	 .	  .    	    .0	.01	.01	<
i3  	+  	.1 	 .	  .   	    .0	.01	.01	<
i3  	+  	.1 	 .	  .   	    .0	.01	.01	0
i3  	+  	.1 	 .	  .   	    .0	.01	.01	1
i3  	+  	.1 	 .	  .   	    .0	.01	.01	<
i3  	+  	.1 	 .	  .   	    .0	.01	.01	<
i3  	+  	.1 	 .	  .   	    .0	.01	.01	<
i3  	+  	.1 	 .	  .   	    .0	.01	.01	<
i3  	+  	.1 	 .	  .    	    .0	.01	.01	<
i3  	+  	.1 	 .	  .   	    .0	.01	.01	<
i3  	+  	.1 	 .	  .   	    .0	.01	.01	0

;4

i3  	+     .2 	 .      8.00	    .1	.01	.01	0
i3  	+  	.2 	 .	  .	          .1	.01	.01	<
i3  	+  	.2 	 .	  .	          .1	.01	.01	<
i3  	+  	.2 	 .	  .    	    .1	.01	.01	<
i3  	+  	.2 	 .	  .    	    .1	.01	.01	<
i3  	+  	.2 	 .	  .    	    .1	.01	.01	<
i3  	+  	.2 	 .	  .    	    .1	.01	.01	<
i3  	+  	.2 	 .	  .    	    .1	.01	.01	<

;5

i3  	+  	.2 	 .	  .    	    .1	.01	.01	<
i3  	+  	.2 	 .	  .   	    .1	.01	.01	<
i3  	+  	.2 	 .	  .   	    .1	.01	.01	<
i3  	+  	.2 	 .	  .   	    .1	.01	.01	<
i3  	+  	.2 	 .	  .   	    .1	.01	.01	<
i3  	+  	.2 	 .	  .   	    .1	.01	.01	<
i3  	+  	.2 	 .	  .   	    .1	.01	.01	<
i3  	+  	.2 	 .	  .   	    .1	.01	.01	1

;6

i3  	+  	.1 	 .	  8.03	    .0	.01	.01	1
i3  	+  	.1 	 .	  .    	    .0	.01	.01	<
i3  	+  	.1 	 .	  .   	    .0	.01	.01	<
i3  	+  	.1 	 .	  .   	    .0	.01	.01	<
i3  	+  	.1 	 .	  .   	    .0	.01	.01	<
i3  	+  	.1 	 .	  .    	    .0	.01	.01	<
i3  	+  	.1 	 .	  .   	    .0	.01	.01	<
i3  	+  	.1 	 .	  .   	    .0	.01	.01	0
i3  	+  	.1 	 .	  8.03	    .0	.01	.01	1
i3  	+  	.1 	 .	  .    	    .0	.01	.01	<
i3  	+  	.1 	 .	  .   	    .0	.01	.01	<
i3  	+  	.1 	 .	  .   	    .0	.01	.01	<
i3  	+  	.1 	 .	  .   	    .0	.01	.01	<
i3  	+  	.1 	 .	  .    	    .0	.01	.01	<
i3  	+  	.1 	 .	  .   	    .0	.01	.01	<
i3  	+  	.1 	 .	  .   	    .0	.01	.01	0

;7

i3  	+  	.1 	 .	  8.03	    .0	.01	.01	1
i3  	+  	.1 	 .	  .    	    .0	.01	.01	<
i3  	+  	.1 	 .	  .   	    .0	.01	.01	<
i3  	+  	.1 	 .	  .   	    .0	.01	.01	<
i3  	+  	.1 	 .	  .   	    .0	.01	.01	<
i3  	+  	.1 	 .	  .    	    .0	.01	.01	<
i3  	+  	.1 	 .	  .   	    .0	.01	.01	<
i3  	+  	.1 	 .	  .   	    .0	.01	.01	0
i3  	+  	.1 	 .	  8.03	    .0	.01	.01	1
i3  	+  	.1 	 .	  .    	    .0	.01	.01	<
i3  	+  	.1 	 .	  .   	    .0	.01	.01	<
i3  	+  	.1 	 .	  .   	    .0	.01	.01	<
i3  	+  	.1 	 .	  .   	    .0	.01	.01	<
i3  	+  	.1 	 .	  .    	    .0	.01	.01	<
i3  	+  	.1 	 .	  .   	    .0	.01	.01	<
i3  	+  	.1 	 .	  .   	    .0	.01	.01	0


; Pan noise
;     strt	dur	 pan   pitch    rev  amp
i21   0     25.6   .5     8.00    .01  100
i21   60.8  11.2   .5     8.00    .01  200
i21   83.2  6.8    .5     8.00    .01  600
i21   86.4  3.6    .5     7.00    .01  300
i21   128.4  12.8    .5     7.00    .01  300
i21   157.2  8    .5     7.00    .01  100



;'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
; Hi-Hat noise
;'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
;     strt	dur	 pan   pitch    rev  amp
i22   19.2  .2  	 .5    6.00     .01  50
i22   +   	.  	 .      .       .    200
i22   +   	.  	 .      .       .    50
i22   +   	.  	 .      .       .    200
i22   +   	.  	 .      .       .    50
i22   +   	.  	 .      .       .    200
i22   +   	.  	 .      .       .    50
i22   +  	.  	 .      .       .    200

i22   +   	.  	 .8     .       .    50
i22   +   	.  	 <      .       .    200
i22   +   	.  	 <      .       .    50
i22   +   	.  	 <      .       .    200
i22   +   	.  	 <      .       .    50
i22   +   	.  	 <      .       .    200
i22   +  	.  	 <      .       .    50
i22   +  	.  	 .2     .       .    200

i22   +     .  	 .5     .       .    50
i22   +   	.  	 .      .       .    200
i22   +   	.  	 .      .       .    50
i22   +   	.  	 .      .       .    200
i22   +   	.  	 .      .       .    50
i22   +   	.  	 .      .       .    200
i22   +   	.  	 .      .       .    50
i22   +  	.  	 .      .       .    200

i22   +   	.  	 .8     .       .    50
i22   +   	.  	 <      .       .    200
i22   +   	.  	 <      .       .    50
i22   +   	.  	 <      .       .    200
i22   +   	.  	 <      .       .    50
i22   +   	.  	 <      .       .    200
i22   +  	.  	 <      .       .    50
i22   +  	.  	 .2     .       .    200
;4

i22   +     .  	 .5     .       .    50
i22   +   	.  	 .      .       .    200
i22   +   	.  	 .      .       .    50
i22   +   	.  	 .      .       .    200
i22   +   	.  	 .      .       .    50
i22   +   	.  	 .      .       .    200
i22   +   	.  	 .      .       .    50
i22   +  	.  	 .      .       .    200

i22   +   	.  	 .8     .       .    50
i22   +   	.  	 <      .       .    200
i22   +   	.  	 <      .       .    50
i22   +   	.  	 <      .       .    200
i22   +   	.  	 <      .       .    50
i22   +   	.  	 <      .       .    200
i22   +  	.  	 <      .       .    50
i22   +  	.  	 .2     .       .    200

;6

i22   +     .  	 .5     .       .    50
i22   +   	.  	 .      .       .    200
i22   +   	.  	 .      .       .    50
i22   +   	.  	 .      .       .    200
i22   +   	.  	 .      .       .    50
i22   +   	.  	 .      .       .    200
i22   +   	.  	 .      .       .    50
i22   +  	.  	 .      .       .    200

i22   +   	.  	 .8     .       .    50
i22   +   	.  	 <      .       .    200
i22   +   	.  	 <      .       .    50
i22   +   	.  	 <      .       .    200
i22   +   	.  	 <      .       .    50
i22   +   	.  	 <      .       .    200
i22   +  	.  	 <      .       .    50
i22   +  	.  	 .2     .       .    200

;8

i22   +     .  	 .5     .       .    50
i22   +   	.  	 .      .       .    200
i22   +   	.  	 .      .       .    50
i22   +   	.  	 .      .       .    200
i22   +   	.  	 .      .       .    50
i22   +   	.  	 .      .       .    200
i22   +   	.  	 .      .       .    50
i22   +  	.  	 .      .       .    200

i22   +   	.  	 .8     .       .    50
i22   +   	.  	 <      .       .    200
i22   +   	.  	 <      .       .    50
i22   +   	.  	 <      .       .    200
i22   +   	.  	 <      .       .    50
i22   +   	.  	 <      .       .    200
i22   +  	.  	 <      .       .    50
i22   +  	.  	 .2     .       .    200

;10

i22   +     .  	 .5     .       .    50
i22   +   	.  	 .      .       .    200
i22   +   	.  	 .      .       .    50
i22   +   	.  	 .      .       .    200
i22   +   	.  	 .      .       .    50
i22   +   	.  	 .      .       .    200
i22   +   	.  	 .      .       .    50
i22   +  	.  	 .      .       .    200

i22   +   	.  	 .8     .       .    50
i22   +   	.  	 <      .       .    200
i22   +   	.  	 <      .       .    50
i22   +   	.  	 <      .       .    200
i22   +   	.  	 <      .       .    50
i22   +   	.  	 <      .       .    200
i22   +  	.  	 <      .       .    50
i22   +  	.  	 .2     .       .    200

;12

i22   +     .  	 .5     .       .    50
i22   +   	.  	 .      .       .    200
i22   +   	.  	 .      .       .    50
i22   +   	.  	 .      .       .    200
i22   +   	.  	 .      .       .    50
i22   +   	.  	 .      .       .    200
i22   +   	.  	 .      .       .    50
i22   +  	.  	 .      .       .    200

i22   +   	.  	 .8     .       .    50
i22   +   	.  	 <      .       .    200
i22   +   	.  	 <      .       .    50
i22   +   	.  	 <      .       .    200
i22   +   	.  	 <      .       .    50
i22   +   	.  	 <      .       .    200
i22   +  	.  	 <      .       .    50
i22   +  	.  	 .2     .       .    200

;14

i22   +     .  	 .5     .       .    50
i22   +   	.  	 .      .       .    200
i22   +   	.  	 .      .       .    50
i22   +   	.  	 .      .       .    200
i22   +   	.  	 .      .       .    50
i22   +   	.  	 .      .       .    200
i22   +   	.  	 .      .       .    50
i22   +  	.  	 .      .       .    200

i22   +   	.  	 .8     .       .    50
i22   +   	.  	 <      .       .    200
i22   +   	.  	 <      .       .    50
i22   +   	.  	 <      .       .    200
i22   +   	.  	 <      .       .    50
i22   +   	.  	 <      .       .    200
i22   +  	.  	 <      .       .    50
i22   +  	.  	 .2     .       .    200

;16

i22   +     .  	 .5     .       .    50
i22   +   	.  	 .      .       .    200
i22   +   	.  	 .      .       .    50
i22   +   	.  	 .      .       .    200
i22   +   	.  	 .      .       .    50
i22   +   	.  	 .      .       .    200
i22   +   	.  	 .      .       .    50
i22   +  	.  	 .      .       .    200

i22   +   	.  	 .8     .       .    50
i22   +   	.  	 <      .       .    200
i22   +   	.  	 <      .       .    50
i22   +   	.  	 <      .       .    200
i22   +   	.  	 <      .       .    50
i22   +   	.  	 <      .       .    200
i22   +  	.  	 <      .       .    50
i22   +  	.  	 .2     .       .    200

;18
;Ends at 48


i22   48 	.1  	 0      6.00   .01   300
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +  	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +  	.  	 <      .       .    .
i22   +  	.  	 1      .       .    .

i22   +   	.1  	 1      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +  	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.05  	 0      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +  	.  	 <      .       .    .
i22   +  	.  	 1      .       .    .

;2

i22   +   	.1  	 0      6.00    .01  .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +  	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +  	.  	 <      .       .    .
i22   +  	.  	 1      .       .    .

i22   +   	.1  	 1      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +  	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.05  	 0      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +  	.  	 <      .       .    .
i22   +  	.  	 1      .       .    .

;4

i22   +   	.1  	 0      6.00    .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +  	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +  	.  	 <      .       .    .
i22   +  	.  	 1      .       .    .

i22   +   	.1  	 1      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +  	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.05  	 0      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +  	.  	 <      .       .    .
i22   +  	.  	 1      .       .    .

;6

i22   +   	.1  	 0      6.00    .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +  	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +  	.  	 <      .       .    .
i22   +  	.  	 1      .       .    .

i22   +   	.1  	 1      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +  	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.05  	 0      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +  	.  	 <      .       .    .
i22   +  	.  	 1      .       .    .

;8
;ends at 60.8


:-------------
i22   60.8 	.1  	 0      6.00   .01   300
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +  	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +  	.  	 <      .       .    .
i22   +  	.  	 1      .       .    .

i22   +   	.1  	 1      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +  	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.05  	 0      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +  	.  	 <      .       .    .
i22   +  	.  	 1      .       .    .

;2

i22   +   	.1  	 0      6.00    .01  .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +  	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +  	.  	 <      .       .    .
i22   +  	.  	 1      .       .    .

i22   +   	.1  	 1      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +  	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.05  	 0      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +  	.  	 <      .       .    .
i22   +  	.  	 1      .       .    .

;4

i22   +   	.1  	 0      6.00    .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +  	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +  	.  	 <      .       .    .
i22   +  	.  	 1      .       .    .

i22   +   	.1  	 1      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +  	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.05  	 0      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +  	.  	 <      .       .    .
i22   +  	.  	 1      .       .    .

;6

i22   +   	.1  	 0      6.00    .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +  	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +  	.  	 <      .       .    .
i22   +  	.  	 1      .       .    .

i22   +   	.1  	 1      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +  	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.05  	 0      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +  	.  	 <      .       .    .
i22   +  	.  	 1      .       .    .

;8

i22   + 	.1  	 0      6.00   .01   300
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +  	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +  	.  	 <      .       .    .
i22   +  	.  	 1      .       .    .

i22   +   	.1  	 1      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +  	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.05  	 0      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +  	.  	 <      .       .    .
i22   +  	.  	 1      .       .    .

;10

i22   +   	.1  	 0      6.00    .01  .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +  	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +  	.  	 <      .       .    .
i22   +  	.  	 1      .       .    .

i22   +   	.1  	 1      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +  	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.05  	 0      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +  	.  	 <      .       .    .
i22   +  	.  	 1      .       .    .

;12

i22   +   	.1  	 0      6.00    .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +  	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +  	.  	 <      .       .    .
i22   +  	.  	 1      .       .    .

i22   +   	.1  	 1      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +  	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.05  	 0      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +  	.  	 <      .       .    .
i22   +  	.  	 1      .       .    .

;14

; Ends at 83,2

i22   90 	.1  	 0      6.00   .01   300
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +  	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +  	.  	 <      .       .    .
i22   +  	.  	 1      .       .    .

i22   +   	.1  	 1      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +  	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.05  	 0      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +  	.  	 <      .       .    .
i22   +  	.  	 1      .       .    .

i22   + 	.1  	 0      6.00   .01   300
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +  	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +  	.  	 <      .       .    .
i22   +  	.  	 1      .       .    .

i22   +   	.1  	 1      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +  	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.05  	 0      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +  	.  	 <      .       .    .
i22   +  	.  	 1      .       .    .

i22   + 	.1  	 0      6.00   .01   300
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +  	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +  	.  	 <      .       .    .
i22   +  	.  	 1      .       .    .

i22   +   	.1  	 1      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +  	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.05  	 0      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +  	.  	 <      .       .    .
i22   +  	.  	 1      .       .    .

i22   + 	.1  	 0      6.00   .01   300
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +  	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +  	.  	 <      .       .    .
i22   +  	.  	 1      .       .    .

i22   +   	.1  	 1      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +  	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.05  	 0      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +  	.  	 <      .       .    .
i22   +  	.  	 1      .       .    .

;8

i22   + 	.1  	 0      6.00   .01   300
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +  	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +  	.  	 <      .       .    .
i22   +  	.  	 1      .       .    .

i22   +   	.1  	 1      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +  	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.05  	 0      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +  	.  	 <      .       .    .
i22   +  	.  	 1      .       .    .

i22   + 	.1  	 0      6.00   .01   300
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +  	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +  	.  	 <      .       .    .
i22   +  	.  	 1      .       .    .

i22   +   	.1  	 1      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +  	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.05  	 0      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +  	.  	 <      .       .    .
i22   +  	.  	 1      .       .    .

i22   + 	.1  	 0      6.00   .01   300
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +  	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +  	.  	 <      .       .    .
i22   +  	.  	 1      .       .    .

i22   +   	.1  	 1      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +  	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.05  	 0      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +  	.  	 <      .       .    .
i22   +  	.  	 1      .       .    .

i22   + 	.1  	 0      6.00   .01   300
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +  	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +  	.  	 <      .       .    .
i22   +  	.  	 1      .       .    .

i22   +   	.1  	 1      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +  	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.05  	 0      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +  	.  	 <      .       .    .
i22   +  	.  	 1      .       .    .

;16

i22   + 	.1  	 0      6.00   .01   300
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +  	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +  	.  	 <      .       .    .
i22   +  	.  	 1      .       .    .

i22   +   	.1  	 1      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +  	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.05  	 0      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +  	.  	 <      .       .    .
i22   +  	.  	 1      .       .    .

i22   + 	.1  	 0      6.00   .01   300
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +  	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +  	.  	 <      .       .    .
i22   +  	.  	 1      .       .    .

i22   +   	.1  	 1      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +  	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.05  	 0      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +  	.  	 <      .       .    .
i22   +  	.  	 1      .       .    .

i22   + 	.1  	 0      6.00   .01   300
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +  	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +  	.  	 <      .       .    .
i22   +  	.  	 1      .       .    .

i22   +   	.1  	 1      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +  	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.05  	 0      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +  	.  	 <      .       .    .
i22   +  	.  	 1      .       .    .

i22   + 	.1  	 0      6.00   .01   300
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +  	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +  	.  	 <      .       .    .
i22   +  	.  	 1      .       .    .

i22   +   	.1  	 1      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +  	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.05  	 0      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +  	.  	 <      .       .    .
i22   +  	.  	 1      .       .    .

;24

i22   + 	.1  	 0      6.00   .01   300
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +  	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +  	.  	 <      .       .    .
i22   +  	.  	 1      .       .    .

i22   +   	.1  	 1      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +  	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.05  	 0      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +  	.  	 <      .       .    .
i22   +  	.  	 1      .       .    .

i22   + 	.1  	 0      6.00   .01   300
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +  	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +  	.  	 <      .       .    .
i22   +  	.  	 1      .       .    .

i22   +   	.1  	 1      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +  	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.05  	 0      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +  	.  	 <      .       .    .
i22   +  	.  	 1      .       .    .

i22   + 	.1  	 0      6.00   .01   300
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +  	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +  	.  	 <      .       .    .
i22   +  	.  	 1      .       .    .

i22   +   	.1  	 1      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +  	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.05  	 0      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +  	.  	 <      .       .    .
i22   +  	.  	 1      .       .    .

i22   + 	.1  	 0      6.00   .01   300
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +  	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +  	.  	 <      .       .    .
i22   +  	.  	 1      .       .    .

i22   +   	.1  	 1      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +  	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.05  	 0      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +   	.  	 <      .       .    .
i22   +  	.  	 <      .       .    .
i22   +  	.  	 1      .       .    .

;32





i22   + 	.1  	 0      6.00   .01   300
i22   +   	.  	 <      .       .    <
i22   +   	.  	 <      .       .    <
i22   +   	.  	 <      .       .    <
i22   +   	.  	 <      .       .    <
i22   +   	.  	 <      .       .    <
i22   +   	.  	 <      .       .    <
i22   +  	.  	 <      .       .    <
i22   +   	.  	 <      .       .    <
i22   +   	.  	 <      .       .    <
i22   +   	.  	 <      .       .    <
i22   +   	.  	 <      .       .    <
i22   +   	.  	 <      .       .    <
i22   +   	.  	 <      .       .    <
i22   +  	.  	 <      .       .    <
i22   +  	.  	 1      .       .    <

i22   +   	.1  	 1      .       .    <
i22   +   	.  	 <      .       .    <
i22   +   	.  	 <      .       .    <
i22   +   	.  	 <      .       .    <
i22   +   	.  	 <      .       .    <
i22   +   	.  	 <      .       .    <
i22   +   	.  	 <      .       .    <
i22   +  	.  	 <      .       .    <
i22   +   	.  	 <      .       .    <
i22   +   	.  	 <      .       .    <
i22   +   	.  	 <      .       .    <
i22   +   	.  	 <      .       .    <
i22   +   	.05  	 0      .       .    <
i22   +   	.  	 <      .       .    <
i22   +   	.  	 <      .       .    <
i22   +   	.  	 <      .       .    <
i22   +   	.  	 <      .       .    <
i22   +   	.  	 <      .       .    <
i22   +  	.  	 <      .       .    <
i22   +  	.  	 1      .       .    <
i22   + 	.1  	 0      6.00   .01   <
i22   +   	.  	 <      .       .    <
i22   +   	.  	 <      .       .    <
i22   +   	.  	 <      .       .    <
i22   +   	.  	 <      .       .    <
i22   +   	.  	 <      .       .    <
i22   +   	.  	 <      .       .    <
i22   +  	.  	 <      .       .    <
i22   +   	.  	 <      .       .    <
i22   +   	.  	 <      .       .    <
i22   +   	.  	 <      .       .    <
i22   +   	.  	 <      .       .    <
i22   +   	.  	 <      .       .    <
i22   +   	.  	 <      .       .    <
i22   +  	.  	 <      .       .    <
i22   +  	.  	 1      .       .    <

i22   +   	.1  	 1      .       .    <
i22   +   	.  	 <      .       .    <
i22   +   	.  	 <      .       .    <
i22   +   	.  	 <      .       .    <
i22   +   	.  	 <      .       .    <
i22   +   	.  	 <      .       .    <
i22   +   	.  	 <      .       .    <
i22   +  	.  	 <      .       .    <
i22   +   	.  	 <      .       .    <
i22   +   	.  	 <      .       .    <
i22   +   	.  	 <      .       .    <
i22   +   	.  	 <      .       .    <
i22   +   	.05  	 0      .       .    <
i22   +   	.  	 <      .       .    <
i22   +   	.  	 <      .       .    <
i22   +   	.  	 <      .       .    <
i22   +   	.  	 <      .       .    <
i22   +   	.  	 <      .       .    <
i22   +  	.  	 <      .       .    <
i22   +  	.  	 1      .       .    <

i22   + 	.1  	 0      6.00   .01   <
i22   +   	.  	 <      .       .    <
i22   +   	.  	 <      .       .    <
i22   +   	.  	 <      .       .    <
i22   +   	.  	 <      .       .    <
i22   +   	.  	 <      .       .    <
i22   +   	.  	 <      .       .    <
i22   +  	.  	 <      .       .    <
i22   +   	.  	 <      .       .    <
i22   +   	.  	 <      .       .    <
i22   +   	.  	 <      .       .    <
i22   +   	.  	 <      .       .    <
i22   +   	.  	 <      .       .    <
i22   +   	.  	 <      .       .    <
i22   +  	.  	 <      .       .    <
i22   +  	.  	 1      .       .    <

i22   +   	.1  	 1      .       .    <
i22   +   	.  	 <      .       .    <
i22   +   	.  	 <      .       .    <
i22   +   	.  	 <      .       .    <
i22   +   	.  	 <      .       .    <
i22   +   	.  	 <      .       .    <
i22   +   	.  	 <      .       .    <
i22   +  	.  	 <      .       .    <
i22   +   	.  	 <      .       .    <
i22   +   	.  	 <      .       .    <
i22   +   	.  	 <      .       .    <
i22   +   	.  	 <      .       .    <
i22   +   	.05  	 0      .       .    <
i22   +   	.  	 <      .       .    <
i22   +   	.  	 <      .       .    <
i22   +   	.  	 <      .       .    <
i22   +   	.  	 <      .       .    <
i22   +   	.  	 <      .       .    <
i22   +  	.  	 <      .       .    <
i22   +  	.  	 1      .       .    <

i22   + 	.1  	 0      6.00   .01   <
i22   +   	.  	 <      .       .    <
i22   +   	.  	 <      .       .    <
i22   +   	.  	 <      .       .    <
i22   +   	.  	 <      .       .    <
i22   +   	.  	 <      .       .    <
i22   +   	.  	 <      .       .    <
i22   +  	.  	 <      .       .    <
i22   +   	.  	 <      .       .    <
i22   +   	.  	 <      .       .    <
i22   +   	.  	 <      .       .    <
i22   +   	.  	 <      .       .    <
i22   +   	.  	 <      .       .    <
i22   +   	.  	 <      .       .    <
i22   +  	.  	 <      .       .    <
i22   +  	.  	 1      .       .    <

i22   +   	.1  	 1      .       .    <
i22   +   	.  	 <      .       .    <
i22   +   	.  	 <      .       .    <
i22   +   	.  	 <      .       .    <
i22   +   	.  	 <      .       .    <
i22   +   	.  	 <      .       .    <
i22   +   	.  	 <      .       .    <
i22   +  	.  	 <      .       .    <
i22   +   	.  	 <      .       .    <
i22   +   	.  	 <      .       .    <
i22   +   	.  	 <      .       .    <
i22   +   	.  	 <      .       .    <
i22   +   	.05  	 0      .       .    <
i22   +   	.  	 <      .       .    <
i22   +   	.  	 <      .       .    <
i22   +   	.  	 <      .       .    <
i22   +   	.  	 <      .       .    <
i22   +   	.  	 <      .       .    <
i22   +  	.  	 <      .       .    <
i22   +  	.  	 1      .       .    0





i22   +   	.  	 .8     .       .    50
i22   +   	.  	 <      .       .    200
i22   +   	.  	 <      .       .    50
i22   +   	.  	 <      .       .    200
i22   +   	.  	 <      .       .    50
i22   +   	.  	 <      .       .    200
i22   +  	.  	 <      .       .    50
i22   +  	.  	 .2     .       .    200

i22   +     .  	 .5     .       .    50
i22   +   	.  	 .      .       .    200
i22   +   	.  	 .      .       .    50
i22   +   	.  	 .      .       .    200
i22   +   	.  	 .      .       .    50
i22   +   	.  	 .      .       .    200
i22   +   	.  	 .      .       .    50
i22   +  	.  	 .      .       .    200






;'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
; METAL noise
;'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
;     strt	dur	 pan   pitch    rev  amp
i23   0     1.6  	 .5    8.00     .05  .0
i23   83.2  1.6  	 .5    1.00     .05  .0


; Sonar noise
;	strt	dur	note	amp	chnlamp	rvrb
i5	83.2	3.2	9.00	900	1		.1
i5	89.6	3.2	9.00	6500	1		.1
i5	102.4	3.2	9.00	1100	1		.1
i5	115.6	3.2	9.00	7500	1		.1
i5	157.2	3.2	9.00	4500	1		.1


;'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
; Kick Drum
;'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
;     strt	dur	 rev  amp
i25   90    .4  	 .0   7
i25   +     .4  	 .0   .
i25   +     .4  	 .0   .
i25   +     .4  	 .0   .

i25   +     .4  	 .0   .
i25   +     .4  	 .0   .
i25   +     .4  	 .0   .
i25   +     .4  	 .0   .

i25   +     .4  	 .0   .
i25   +     .4  	 .0   .
i25   +     .4  	 .0   .
i25   +     .4  	 .0   .

i25   +     .4  	 .0   .
i25   +     .4  	 .0   .
i25   +     .4  	 .0   .
i25   +     .4  	 .0   .

i25   +     .4  	 .0   .
i25   +     .4  	 .0   .
i25   +     .4  	 .0   .
i25   +     .4  	 .0   .

i25   +     .4  	 .0   .
i25   +     .4  	 .0   .
i25   +     .4  	 .0   .
i25   +     .4  	 .0   .

i25   +     .4  	 .0   .
i25   +     .4  	 .0   .
i25   +     .4  	 .0   .
i25   +     .4  	 .0   .

i25   +     .4  	 .0   .
i25   +     .4  	 .0   .
i25   +     .4  	 .0   .
i25   +     .4  	 .0   .

;8

i25   +     .4  	 .0   7
i25   +     .4  	 .0   .
i25   +     .4  	 .0   .
i25   +     .4  	 .0   .

i25   +     .4  	 .0   .
i25   +     .4  	 .0   .
i25   +     .4  	 .0   .
i25   +     .4  	 .0   .

i25   +     .4  	 .0   .
i25   +     .4  	 .0   .
i25   +     .4  	 .0   .
i25   +     .4  	 .0   .

i25   +     .4  	 .0   .
i25   +     .4  	 .0   .
i25   +     .4  	 .0   .
i25   +     .4  	 .0   .

i25   +     .4  	 .0   .
i25   +     .4  	 .0   .
i25   +     .4  	 .0   .
i25   +     .4  	 .0   .

i25   +     .4  	 .0   .
i25   +     .4  	 .0   .
i25   +     .4  	 .0   .
i25   +     .4  	 .0   .

i25   +     .4  	 .0   .
i25   +     .4  	 .0   .
i25   +     .4  	 .0   .
i25   +     .4  	 .0   .

i25   +     .4  	 .0   .
i25   +     .4  	 .0   .
i25   +     .4  	 .0   .
i25   +     .4  	 .0   .

;16

i25   +     .4  	 .0   7
i25   +     .4  	 .0   .
i25   +     .4  	 .0   .
i25   +     .4  	 .0   .

i25   +     .4  	 .0   .
i25   +     .4  	 .0   .
i25   +     .4  	 .0   .
i25   +     .4  	 .0   .

i25   +     .4  	 .0   .
i25   +     .4  	 .0   .
i25   +     .4  	 .0   .
i25   +     .4  	 .0   .

i25   +     .4  	 .0   .
i25   +     .4  	 .0   .
i25   +     .4  	 .0   .
i25   +     .4  	 .0   .

i25   +     .4  	 .0   .
i25   +     .4  	 .0   .
i25   +     .4  	 .0   .
i25   +     .4  	 .0   .

i25   +     .4  	 .0   .
i25   +     .4  	 .0   .
i25   +     .4  	 .0   .
i25   +     .4  	 .0   .

i25   +     .4  	 .0   .
i25   +     .4  	 .0   .
i25   +     .4  	 .0   .
i25   +     .4  	 .0   .

i25   +     .4  	 .0   .
i25   +     .4  	 .0   .
i25   +     .4  	 .0   .
i25   +     .4  	 .0   .

;24

i25   +     .4  	 .0   7
i25   +     .4  	 .0   .
i25   +     .4  	 .0   .
i25   +     .4  	 .0   .

i25   +     .4  	 .0   .
i25   +     .4  	 .0   .
i25   +     .4  	 .0   .
i25   +     .4  	 .0   .

i25   +     .4  	 .0   .
i25   +     .4  	 .0   .
i25   +     .4  	 .0   .
i25   +     .4  	 .0   .

i25   +     .4  	 .0   .
i25   +     .4  	 .0   .
i25   +     .4  	 .0   .
i25   +     .4  	 .0   .

i25   +     .4  	 .0   .
i25   +     .4  	 .0   .
i25   +     .4  	 .0   .
i25   +     .4  	 .0   .

i25   +     .4  	 .0   .
i25   +     .4  	 .0   .
i25   +     .4  	 .0   .
i25   +     .4  	 .0   .

i25   +     .4  	 .0   .
i25   +     .4  	 .0   .
i25   +     .4  	 .0   .
i25   +     .4  	 .0   .

i25   +     .4  	 .0   .
i25   +     .4  	 .0   .
i25   +     .4  	 .0   .
i25   +     .4  	 .0   .

;32

i25   +     .4  	 .0   7
i25   +     .4  	 .0   <
i25   +     .4  	 .0   <
i25   +     .4  	 .0   <
i25   +     .4  	 .0   <
i25   +     .4  	 .0   <
i25   +     .4  	 .0   <
i25   +     .4  	 .0   <
i25   +     .4  	 .0   <
i25   +     .4  	 .0   <
i25   +     .4  	 .0   <
i25   +     .4  	 .0   <

i25   +     .4  	 .0   <
i25   +     .4  	 .0   <
i25   +     .4  	 .0   <
i25   +     .4  	 .0   <

i25   +     .4  	 .0   <
i25   +     .4  	 .0   <
i25   +     .4  	 .0   <
i25   +     .4  	 .0   <

i25   +     .4  	 .0   <
i25   +     .4  	 .0   <
i25   +     .4  	 .0   <
i25   +     .4  	 .0   <

i25   +     .4  	 .0   <
i25   +     .4  	 .0   <
i25   +     .4  	 .0   <
i25   +     .4  	 .0   <

i25   +     .4  	 .0   <
i25   +     .4  	 .0   <
i25   +     .4  	 .0   <
i25   +     .4  	 .0   0




i25   +     .4  	 .0   <
i25   +     .4  	 .0   <
i25   +     .4  	 .0   <
i25   +     .4  	 .0   <

i25   +     .4  	 .0   <
i25   +     .4  	 .0   <
i25   +     .4  	 .0   <
i25   +     .4  	 .0   0

e	



</CsScore>
</CsoundSynthesizer>
<bsbPanel>
 <label>Widgets</label>
 <objectName/>
 <x>100</x>
 <y>100</y>
 <width>320</width>
 <height>240</height>
 <visible>true</visible>
 <uuid/>
 <bgcolor mode="nobackground">
  <r>255</r>
  <g>255</g>
  <b>255</b>
 </bgcolor>
</bsbPanel>
<bsbPresets>
</bsbPresets>
